/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.vectors.mapper.VectorEncoderDecoder;
import org.elasticsearch.xpack.vectors.query.VectorDVIndexFieldData;

public class SparseVectorFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "sparse_vector";
    public static short MAX_DIMS_COUNT = (short)1024;
    public static int MAX_DIMS_NUMBER = 65535;

    private SparseVectorFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions() == IndexOptions.NONE);
    }

    protected SparseVectorFieldMapper clone() {
        return (SparseVectorFieldMapper)super.clone();
    }

    public SparseVectorFieldType fieldType() {
        return (SparseVectorFieldType)super.fieldType();
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] can't be used in multi-fields");
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)context.parser().currentToken(), () -> ((XContentParser)context.parser()).getTokenLocation());
        int[] dims = new int[]{};
        float[] values = new float[]{};
        int dimCount = 0;
        int dim = 0;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            block10: {
                if (token == XContentParser.Token.FIELD_NAME) {
                    try {
                        dim = Integer.parseInt(context.parser().currentName());
                        if (dim < 0 || dim > MAX_DIMS_NUMBER) {
                            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "]'s dimension number must be a non-negative integer value not exceeding [" + MAX_DIMS_NUMBER + "], got [" + dim + "]");
                        }
                        break block10;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "]'s dimensions should be integers represented as strings, but got [" + context.parser().currentName() + "]", e);
                    }
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    float value = context.parser().floatValue(true);
                    if (dims.length <= dimCount) {
                        values = ArrayUtil.grow((float[])values, (int)(dimCount + 1));
                        dims = ArrayUtil.grow((int[])dims, (int)(dimCount + 1));
                    }
                    dims[dimCount] = dim;
                    values[dimCount] = value;
                    if (dimCount++ >= MAX_DIMS_COUNT) {
                        throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] has exceeded the maximum allowed number of dimensions of [" + MAX_DIMS_COUNT + "]");
                    }
                } else {
                    throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] takes an object that maps a dimension number to a float, but got unexpected token [" + token + "]");
                }
            }
            token = context.parser().nextToken();
        }
        BytesRef br = VectorEncoderDecoder.encodeSparseVector(this.indexCreatedVersion, dims, values, dimCount);
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), br);
        context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class SparseVectorFieldType
    extends MappedFieldType {
        public SparseVectorFieldType() {
        }

        protected SparseVectorFieldType(SparseVectorFieldType ref) {
            super((MappedFieldType)ref);
        }

        public SparseVectorFieldType clone() {
            return new SparseVectorFieldType(this);
        }

        public String typeName() {
            return SparseVectorFieldMapper.CONTENT_TYPE;
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            return new VectorDVIndexFieldData.Builder(false);
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support queries");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, SparseVectorFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public SparseVectorFieldType fieldType() {
            return (SparseVectorFieldType)super.fieldType();
        }

        public SparseVectorFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new SparseVectorFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new SparseVectorFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

