/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.vectors.VectorsFeatureSetUsage;

public class VectorsFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;

    @Inject
    public VectorsFeatureSet(Settings settings, XPackLicenseState licenseState, ClusterService clusterService) {
        this.enabled = (Boolean)XPackSettings.VECTORS_ENABLED.get(settings);
        this.licenseState = licenseState;
        this.clusterService = clusterService;
    }

    public String name() {
        return "vectors";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isVectorsAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        boolean vectorsAvailable = this.available();
        boolean vectorsEnabled = this.enabled();
        int numDenseVectorFields = 0;
        int numSparseVectorFields = 0;
        int avgDenseVectorDims = 0;
        if (vectorsAvailable && vectorsEnabled && this.clusterService.state() != null) {
            for (IndexMetaData indexMetaData : this.clusterService.state().metaData()) {
                Map mappings;
                MappingMetaData mappingMetaData = indexMetaData.mapping();
                if (mappingMetaData == null || !(mappings = mappingMetaData.getSourceAsMap()).containsKey("properties")) continue;
                Map fieldMappings = (Map)mappings.get("properties");
                for (Map typeDefinition : fieldMappings.values()) {
                    String fieldType = (String)typeDefinition.get("type");
                    if (fieldType == null) continue;
                    if (fieldType.equals("dense_vector")) {
                        ++numDenseVectorFields;
                        int dims = (Integer)typeDefinition.get("dims");
                        avgDenseVectorDims += dims;
                        continue;
                    }
                    if (!fieldType.equals("sparse_vector")) continue;
                    ++numSparseVectorFields;
                }
            }
            if (numDenseVectorFields > 0) {
                avgDenseVectorDims /= numDenseVectorFields;
            }
        }
        listener.onResponse((Object)new VectorsFeatureSetUsage(vectorsAvailable, vectorsEnabled, numDenseVectorFields, numSparseVectorFields, avgDenseVectorDims));
    }
}

