/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.vectors.VectorsFeatureSet;
import org.elasticsearch.xpack.vectors.mapper.DenseVectorFieldMapper;
import org.elasticsearch.xpack.vectors.mapper.SparseVectorFieldMapper;

public class Vectors
extends Plugin
implements MapperPlugin {
    public static final String NAME = "vectors";
    protected final boolean enabled;

    public Vectors(Settings settings) {
        this.enabled = (Boolean)XPackSettings.VECTORS_ENABLED.get(settings);
    }

    public Collection<Module> createGuiceModules() {
        return Collections.singletonList(b -> XPackPlugin.bindFeatureSet((Binder)b, VectorsFeatureSet.class));
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> mappers = new LinkedHashMap<String, Object>();
        mappers.put("dense_vector", new DenseVectorFieldMapper.TypeParser());
        mappers.put("sparse_vector", new SparseVectorFieldMapper.TypeParser());
        return Collections.unmodifiableMap(mappers);
    }
}

