/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.pivot.GroupConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.PivotConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.xpack.transform.transforms.pivot.AggregationResultUtils;
import org.elasticsearch.xpack.transform.transforms.pivot.Aggregations;
import org.elasticsearch.xpack.transform.transforms.pivot.SchemaUtil;

public class Pivot {
    public static final int DEFAULT_INITIAL_PAGE_SIZE = 500;
    public static final int TEST_QUERY_PAGE_SIZE = 50;
    private static final String COMPOSITE_AGGREGATION_NAME = "_transform";
    private static final Logger logger = LogManager.getLogger(Pivot.class);
    private final PivotConfig config;
    private final boolean supportsIncrementalBucketUpdate;
    private final CompositeAggregationBuilder cachedCompositeAggregation;

    public Pivot(PivotConfig config) {
        this.config = config;
        this.cachedCompositeAggregation = Pivot.createCompositeAggregation(config);
        boolean supportsIncrementalBucketUpdate = false;
        for (Map.Entry entry : config.getGroupConfig().getGroups().entrySet()) {
            supportsIncrementalBucketUpdate |= ((SingleGroupSource)entry.getValue()).supportsIncrementalBucketUpdate();
        }
        this.supportsIncrementalBucketUpdate = supportsIncrementalBucketUpdate;
    }

    public void validateConfig() {
        for (AggregationBuilder agg : this.config.getAggregationConfig().getAggregatorFactories()) {
            if (Aggregations.isSupportedByTransform(agg.getType())) continue;
            throw new ElasticsearchStatusException("Unsupported aggregation type [" + agg.getType() + "]", RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    public void validateQuery(Client client, SourceConfig sourceConfig, ActionListener<Boolean> listener) {
        SearchRequest searchRequest = this.buildSearchRequest(sourceConfig, null, 50);
        client.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(response -> {
            if (response == null) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Unexpected null response from test query", RestStatus.SERVICE_UNAVAILABLE, new Object[0]));
                return;
            }
            if (response.status() != RestStatus.OK) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Unexpected status from response of test query: " + response.status(), response.status(), new Object[0]));
                return;
            }
            listener.onResponse((Object)true);
        }, e -> listener.onFailure((Exception)new ElasticsearchStatusException("Failed to test query", RestStatus.SERVICE_UNAVAILABLE, (Throwable)e, new Object[0]))));
    }

    public void deduceMappings(Client client, SourceConfig sourceConfig, ActionListener<Map<String, String>> listener) {
        SchemaUtil.deduceMappings(client, this.config, sourceConfig.getIndex(), listener);
    }

    public int getInitialPageSize() {
        return this.config.getMaxPageSearchSize() == null ? 500 : this.config.getMaxPageSearchSize();
    }

    public SearchRequest buildSearchRequest(SourceConfig sourceConfig, Map<String, Object> position, int pageSize) {
        QueryBuilder queryBuilder = sourceConfig.getQueryConfig().getQuery();
        SearchRequest searchRequest = new SearchRequest(sourceConfig.getIndex());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.aggregation(this.buildAggregation(position, pageSize));
        sourceBuilder.size(0);
        sourceBuilder.query(queryBuilder);
        searchRequest.source(sourceBuilder);
        searchRequest.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        return searchRequest;
    }

    public AggregationBuilder buildAggregation(Map<String, Object> position, int pageSize) {
        this.cachedCompositeAggregation.aggregateAfter(position);
        this.cachedCompositeAggregation.size(pageSize);
        return this.cachedCompositeAggregation;
    }

    public CompositeAggregationBuilder buildIncrementalBucketUpdateAggregation(int pageSize) {
        CompositeAggregationBuilder compositeAgg = Pivot.createCompositeAggregationSources(this.config, true);
        compositeAgg.size(pageSize);
        return compositeAgg;
    }

    public Map<String, Set<String>> initialIncrementalBucketUpdateMap() {
        HashMap<String, Set<String>> changedBuckets = new HashMap<String, Set<String>>();
        for (Map.Entry entry : this.config.getGroupConfig().getGroups().entrySet()) {
            if (!((SingleGroupSource)entry.getValue()).supportsIncrementalBucketUpdate()) continue;
            changedBuckets.put((String)entry.getKey(), new HashSet());
        }
        return changedBuckets;
    }

    public boolean supportsIncrementalBucketUpdate() {
        return this.supportsIncrementalBucketUpdate;
    }

    public Stream<Map<String, Object>> extractResults(CompositeAggregation agg, Map<String, String> fieldTypeMap, TransformIndexerStats transformIndexerStats) {
        GroupConfig groups = this.config.getGroupConfig();
        Collection aggregationBuilders = this.config.getAggregationConfig().getAggregatorFactories();
        Collection pipelineAggregationBuilders = this.config.getAggregationConfig().getPipelineAggregatorFactories();
        return AggregationResultUtils.extractCompositeAggregationResults(agg, groups, aggregationBuilders, pipelineAggregationBuilders, fieldTypeMap, transformIndexerStats);
    }

    public QueryBuilder filterBuckets(Map<String, Set<String>> changedBuckets) {
        if (changedBuckets == null || changedBuckets.isEmpty()) {
            return null;
        }
        if (this.config.getGroupConfig().getGroups().size() == 1) {
            Map.Entry entry = this.config.getGroupConfig().getGroups().entrySet().iterator().next();
            assert (((SingleGroupSource)entry.getValue()).supportsIncrementalBucketUpdate());
            logger.trace("filter by bucket: " + (String)entry.getKey() + "/" + ((SingleGroupSource)entry.getValue()).getField());
            if (changedBuckets.containsKey(entry.getKey())) {
                return ((SingleGroupSource)entry.getValue()).getIncrementalBucketUpdateFilterQuery(changedBuckets.get(entry.getKey()));
            }
            throw new RuntimeException("Could not find bucket value for key " + (String)entry.getKey());
        }
        BoolQueryBuilder filteredQuery = new BoolQueryBuilder();
        for (Map.Entry entry : this.config.getGroupConfig().getGroups().entrySet()) {
            if (!((SingleGroupSource)entry.getValue()).supportsIncrementalBucketUpdate()) continue;
            if (changedBuckets.containsKey(entry.getKey())) {
                QueryBuilder sourceQueryFilter = ((SingleGroupSource)entry.getValue()).getIncrementalBucketUpdateFilterQuery(changedBuckets.get(entry.getKey()));
                if (sourceQueryFilter == null) continue;
                filteredQuery.filter(sourceQueryFilter);
                continue;
            }
            throw new RuntimeException("Could not find bucket value for key " + (String)entry.getKey());
        }
        return filteredQuery;
    }

    private static CompositeAggregationBuilder createCompositeAggregation(PivotConfig config) {
        CompositeAggregationBuilder compositeAggregation = Pivot.createCompositeAggregationSources(config, false);
        config.getAggregationConfig().getAggregatorFactories().forEach(agg -> compositeAggregation.subAggregation(agg));
        config.getAggregationConfig().getPipelineAggregatorFactories().forEach(agg -> compositeAggregation.subAggregation(agg));
        return compositeAggregation;
    }

    private static CompositeAggregationBuilder createCompositeAggregationSources(PivotConfig config, boolean forChangeDetection) {
        CompositeAggregationBuilder compositeAggregation;
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            config.toCompositeAggXContent(builder, forChangeDetection);
            XContentParser parser = builder.generator().contentType().xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)builder).streamInput());
            compositeAggregation = CompositeAggregationBuilder.parse((String)COMPOSITE_AGGREGATION_NAME, (XContentParser)parser);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create composite aggregation from pivot function", e);
        }
        return compositeAggregation;
    }
}

