/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.indexing.AsyncTwoPhaseIndexer;
import org.elasticsearch.xpack.core.indexing.IndexerJobStats;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.indexing.IterationResult;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.transforms.pivot.Pivot;

public abstract class TransformIndexer
extends AsyncTwoPhaseIndexer<TransformIndexerPosition, TransformIndexerStats> {
    public static final int MINIMUM_PAGE_SIZE = 10;
    public static final String COMPOSITE_AGGREGATION_NAME = "_transform";
    private static final Logger logger = LogManager.getLogger(TransformIndexer.class);
    protected final TransformAuditor auditor;
    protected volatile TransformConfig transformConfig;
    protected volatile TransformProgress progress;
    private final Map<String, String> fieldMappings;
    private Pivot pivot;
    private int pageSize = 0;
    protected volatile TransformCheckpoint lastCheckpoint;
    protected volatile TransformCheckpoint nextCheckpoint;
    private volatile RunState runState;
    private volatile Map<String, Set<String>> changedBuckets;
    private volatile Map<String, Object> changedBucketsAfterKey;

    public TransformIndexer(Executor executor, TransformAuditor auditor, TransformConfig transformConfig, Map<String, String> fieldMappings, AtomicReference<IndexerState> initialState, TransformIndexerPosition initialPosition, TransformIndexerStats jobStats, TransformProgress transformProgress, TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint) {
        super(executor, initialState, (Object)initialPosition, (IndexerJobStats)jobStats);
        this.auditor = Objects.requireNonNull(auditor);
        this.transformConfig = (TransformConfig)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull((Object)transformConfig, (String)"transformConfig");
        this.fieldMappings = (Map)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull(fieldMappings, (String)"fieldMappings");
        this.progress = transformProgress;
        this.lastCheckpoint = lastCheckpoint;
        this.nextCheckpoint = nextCheckpoint;
        this.runState = RunState.FULL_RUN;
    }

    protected abstract void failIndexer(String var1);

    public int getPageSize() {
        return this.pageSize;
    }

    protected String getJobId() {
        return this.transformConfig.getId();
    }

    public TransformConfig getConfig() {
        return this.transformConfig;
    }

    public boolean isContinuous() {
        return this.getConfig().getSyncConfig() != null;
    }

    public Map<String, String> getFieldMappings() {
        return this.fieldMappings;
    }

    public TransformProgress getProgress() {
        return this.progress;
    }

    public TransformCheckpoint getLastCheckpoint() {
        return this.lastCheckpoint;
    }

    public TransformCheckpoint getNextCheckpoint() {
        return this.nextCheckpoint;
    }

    protected abstract void createCheckpoint(ActionListener<TransformCheckpoint> var1);

    protected void onStart(long now, ActionListener<Boolean> listener) {
        try {
            this.pivot = new Pivot(this.getConfig().getPivotConfig());
            if (this.pageSize == 0) {
                this.pageSize = this.pivot.getInitialPageSize();
            }
            this.runState = this.determineRunStateAtStart();
            listener.onResponse((Object)true);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected boolean initialRun() {
        return this.getPosition() == null;
    }

    protected void onFinish(ActionListener<Void> listener) {
        this.pageSize = this.pivot.getInitialPageSize();
        this.changedBuckets = null;
    }

    protected IterationResult<TransformIndexerPosition> doProcess(SearchResponse searchResponse) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            logger.info("[" + this.getJobId() + "] unexpected null aggregations in search response. Source indices have been deleted or closed.");
            this.auditor.info(this.getJobId(), "Source indices have been deleted or closed. Please verify that these indices exist and are open [" + Strings.arrayToCommaDelimitedString((Object[])this.getConfig().getSource().getIndex()) + "].");
            return new IterationResult(Collections.emptyList(), null, true);
        }
        CompositeAggregation agg = (CompositeAggregation)aggregations.get(COMPOSITE_AGGREGATION_NAME);
        switch (this.runState) {
            case FULL_RUN: {
                return this.processBuckets(agg);
            }
            case PARTIAL_RUN_APPLY_CHANGES: {
                return this.processPartialBucketUpdates(agg);
            }
            case PARTIAL_RUN_IDENTIFY_CHANGES: {
                return this.processChangedBuckets(agg);
            }
        }
        logger.warn("Encountered unexpected run state [" + (Object)((Object)this.runState) + "]");
        throw new IllegalStateException("DataFrame indexer job encountered an illegal state [" + (Object)((Object)this.runState) + "]");
    }

    private IterationResult<TransformIndexerPosition> processBuckets(CompositeAggregation agg) {
        if (agg.getBuckets().isEmpty()) {
            return new IterationResult(Collections.emptyList(), null, true);
        }
        long docsBeforeProcess = ((TransformIndexerStats)this.getStats()).getNumDocuments();
        TransformIndexerPosition oldPosition = (TransformIndexerPosition)this.getPosition();
        TransformIndexerPosition newPosition = new TransformIndexerPosition(agg.afterKey(), oldPosition != null ? ((TransformIndexerPosition)this.getPosition()).getBucketsPosition() : null);
        IterationResult result = new IterationResult(this.processBucketsToIndexRequests(agg).collect(Collectors.toList()), (Object)newPosition, agg.getBuckets().isEmpty());
        if (this.progress != null) {
            this.progress.incrementDocsProcessed(((TransformIndexerStats)this.getStats()).getNumDocuments() - docsBeforeProcess);
            this.progress.incrementDocsIndexed((long)result.getToIndex().size());
        }
        return result;
    }

    private IterationResult<TransformIndexerPosition> processPartialBucketUpdates(CompositeAggregation agg) {
        if (agg.getBuckets().isEmpty()) {
            this.changedBuckets = null;
            this.runState = RunState.PARTIAL_RUN_IDENTIFY_CHANGES;
            return new IterationResult(Collections.emptyList(), (Object)new TransformIndexerPosition(null, this.changedBucketsAfterKey), false);
        }
        return this.processBuckets(agg);
    }

    private IterationResult<TransformIndexerPosition> processChangedBuckets(CompositeAggregation agg) {
        this.changedBuckets = this.pivot.initialIncrementalBucketUpdateMap();
        if (agg.getBuckets().isEmpty()) {
            this.changedBuckets = null;
            this.changedBucketsAfterKey = null;
            return new IterationResult(Collections.emptyList(), null, true);
        }
        agg.getBuckets().stream().forEach(bucket -> bucket.getKey().forEach((k, v) -> this.changedBuckets.get(k).add(v.toString())));
        this.changedBucketsAfterKey = agg.afterKey();
        this.runState = RunState.PARTIAL_RUN_APPLY_CHANGES;
        return new IterationResult(Collections.emptyList(), (Object)((TransformIndexerPosition)this.getPosition()), false);
    }

    private Stream<IndexRequest> processBucketsToIndexRequests(CompositeAggregation agg) {
        TransformConfig transformConfig = this.getConfig();
        String indexName = transformConfig.getDestination().getIndex();
        return this.pivot.extractResults(agg, this.getFieldMappings(), (TransformIndexerStats)this.getStats()).map(document -> {
            XContentBuilder builder;
            String id = (String)document.get(TransformField.DOCUMENT_ID_FIELD);
            if (id == null) {
                throw new RuntimeException("Expected a document id but got null.");
            }
            try {
                builder = XContentFactory.jsonBuilder();
                builder.startObject();
                for (Map.Entry value : document.entrySet()) {
                    if (((String)value.getKey()).startsWith("_")) continue;
                    builder.field((String)value.getKey(), value.getValue());
                }
                builder.endObject();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            IndexRequest request = new IndexRequest(indexName).source(builder).id(id);
            if (transformConfig.getDestination().getPipeline() != null) {
                request.setPipeline(transformConfig.getDestination().getPipeline());
            }
            return request;
        });
    }

    protected QueryBuilder buildFilterQuery() {
        assert (this.nextCheckpoint != null);
        QueryBuilder pivotQueryBuilder = this.getConfig().getSource().getQueryConfig().getQuery();
        TransformConfig config = this.getConfig();
        if (this.isContinuous()) {
            BoolQueryBuilder filteredQuery = new BoolQueryBuilder().filter(pivotQueryBuilder);
            if (this.lastCheckpoint != null) {
                filteredQuery.filter(config.getSyncConfig().getRangeQuery(this.lastCheckpoint, this.nextCheckpoint));
            } else {
                filteredQuery.filter(config.getSyncConfig().getRangeQuery(this.nextCheckpoint));
            }
            return filteredQuery;
        }
        return pivotQueryBuilder;
    }

    protected SearchRequest buildSearchRequest() {
        assert (this.nextCheckpoint != null);
        SearchRequest searchRequest = new SearchRequest(this.getConfig().getSource().getIndex()).allowPartialSearchResults(false).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().size(0);
        switch (this.runState) {
            case FULL_RUN: {
                this.buildFullRunQuery(sourceBuilder);
                break;
            }
            case PARTIAL_RUN_IDENTIFY_CHANGES: {
                this.buildChangedBucketsQuery(sourceBuilder);
                break;
            }
            case PARTIAL_RUN_APPLY_CHANGES: {
                this.buildPartialUpdateQuery(sourceBuilder);
                break;
            }
            default: {
                logger.warn("Encountered unexpected run state [" + (Object)((Object)this.runState) + "]");
                throw new IllegalStateException("DataFrame indexer job encountered an illegal state [" + (Object)((Object)this.runState) + "]");
            }
        }
        searchRequest.source(sourceBuilder);
        return searchRequest;
    }

    private SearchSourceBuilder buildFullRunQuery(SearchSourceBuilder sourceBuilder) {
        TransformIndexerPosition position = (TransformIndexerPosition)this.getPosition();
        sourceBuilder.aggregation(this.pivot.buildAggregation(position != null ? position.getIndexerPosition() : null, this.pageSize));
        TransformConfig config = this.getConfig();
        QueryBuilder pivotQueryBuilder = config.getSource().getQueryConfig().getQuery();
        if (this.isContinuous()) {
            BoolQueryBuilder filteredQuery = new BoolQueryBuilder().filter(pivotQueryBuilder).filter(config.getSyncConfig().getRangeQuery(this.nextCheckpoint));
            sourceBuilder.query((QueryBuilder)filteredQuery);
        } else {
            sourceBuilder.query(pivotQueryBuilder);
        }
        logger.trace("running full run query: {}", (Object)sourceBuilder);
        return sourceBuilder;
    }

    private SearchSourceBuilder buildChangedBucketsQuery(SearchSourceBuilder sourceBuilder) {
        assert (this.isContinuous());
        TransformIndexerPosition position = (TransformIndexerPosition)this.getPosition();
        CompositeAggregationBuilder changesAgg = this.pivot.buildIncrementalBucketUpdateAggregation(this.pageSize);
        changesAgg.aggregateAfter(position != null ? position.getBucketsPosition() : null);
        sourceBuilder.aggregation((AggregationBuilder)changesAgg);
        QueryBuilder pivotQueryBuilder = this.getConfig().getSource().getQueryConfig().getQuery();
        TransformConfig config = this.getConfig();
        BoolQueryBuilder filteredQuery = new BoolQueryBuilder().filter(pivotQueryBuilder).filter(config.getSyncConfig().getRangeQuery(this.lastCheckpoint, this.nextCheckpoint));
        sourceBuilder.query((QueryBuilder)filteredQuery);
        logger.trace("running changes query {}", (Object)sourceBuilder);
        return sourceBuilder;
    }

    private SearchSourceBuilder buildPartialUpdateQuery(SearchSourceBuilder sourceBuilder) {
        QueryBuilder pivotFilter;
        assert (this.isContinuous());
        TransformIndexerPosition position = (TransformIndexerPosition)this.getPosition();
        sourceBuilder.aggregation(this.pivot.buildAggregation(position != null ? position.getIndexerPosition() : null, this.pageSize));
        TransformConfig config = this.getConfig();
        QueryBuilder pivotQueryBuilder = config.getSource().getQueryConfig().getQuery();
        BoolQueryBuilder filteredQuery = new BoolQueryBuilder().filter(pivotQueryBuilder).filter(config.getSyncConfig().getRangeQuery(this.nextCheckpoint));
        if (this.changedBuckets != null && !this.changedBuckets.isEmpty() && (pivotFilter = this.pivot.filterBuckets(this.changedBuckets)) != null) {
            filteredQuery.filter(pivotFilter);
        }
        sourceBuilder.query((QueryBuilder)filteredQuery);
        logger.trace("running partial update query: {}", (Object)sourceBuilder);
        return sourceBuilder;
    }

    protected boolean handleCircuitBreakingException(Exception e) {
        CircuitBreakingException circuitBreakingException = TransformIndexer.getCircuitBreakingException(e);
        if (circuitBreakingException == null) {
            return false;
        }
        double reducingFactor = Math.min((double)circuitBreakingException.getByteLimit() / (double)circuitBreakingException.getBytesWanted(), 1.0 - Math.log10(this.pageSize) * 0.1);
        int newPageSize = (int)Math.round(reducingFactor * (double)this.pageSize);
        if (newPageSize < 10) {
            String message = TransformMessages.getMessage((String)"Insufficient memory for search after repeated page size reductions to [{0}], unable to continue pivot, please simplify job or increase heap size on data nodes.", (Object[])new Object[]{this.pageSize});
            this.failIndexer(message);
            return true;
        }
        String message = TransformMessages.getMessage((String)"Insufficient memory for search, reducing number of buckets per search from [{0}] to [{1}]", (Object[])new Object[]{this.pageSize, newPageSize});
        this.auditor.info(this.getJobId(), message);
        logger.info("Data frame transform [" + this.getJobId() + "]:" + message);
        this.pageSize = newPageSize;
        return true;
    }

    private RunState determineRunStateAtStart() {
        if (this.nextCheckpoint.getCheckpoint() == 1L || !this.isContinuous()) {
            return RunState.FULL_RUN;
        }
        if (!this.pivot.supportsIncrementalBucketUpdate()) {
            return RunState.FULL_RUN;
        }
        return RunState.PARTIAL_RUN_IDENTIFY_CHANGES;
    }

    private static CircuitBreakingException getCircuitBreakingException(Exception e) {
        Throwable unwrappedThrowable = ExceptionsHelper.unwrapCause((Throwable)e);
        if (unwrappedThrowable instanceof CircuitBreakingException) {
            return (CircuitBreakingException)unwrappedThrowable;
        }
        if (unwrappedThrowable instanceof SearchPhaseExecutionException) {
            SearchPhaseExecutionException searchPhaseException = (SearchPhaseExecutionException)e;
            for (ShardSearchFailure shardFailure : searchPhaseException.shardFailures()) {
                Throwable unwrappedShardFailure = ExceptionsHelper.unwrapCause((Throwable)shardFailure.getCause());
                if (!(unwrappedShardFailure instanceof CircuitBreakingException)) continue;
                return (CircuitBreakingException)unwrappedShardFailure;
            }
        }
        return null;
    }

    protected abstract void sourceHasChanged(ActionListener<Boolean> var1);

    private static enum RunState {
        FULL_RUN,
        PARTIAL_RUN_IDENTIFY_CHANGES,
        PARTIAL_RUN_APPLY_CHANGES;

    }
}

