/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public final class SourceDestValidator {
    private static final List<SourceDestValidation> VALIDATIONS = Arrays.asList(new SourceMissingValidation(), new DestinationInSourceValidation(), new DestinationSingleIndexValidation());

    public static void validate(TransformConfig config, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver, boolean shouldDefer) {
        for (SourceDestValidation validation : VALIDATIONS) {
            if (shouldDefer && validation.isDeferrable()) continue;
            validation.validate(config, clusterState, indexNameExpressionResolver);
        }
    }

    static class DestinationSingleIndexValidation
    implements SourceDestValidation {
        DestinationSingleIndexValidation() {
        }

        @Override
        public boolean isDeferrable() {
            return false;
        }

        @Override
        public void validate(TransformConfig config, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
            String destIndex = config.getDestination().getIndex();
            String[] concreteDest = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{destIndex});
            if (concreteDest.length > 1) {
                throw new ElasticsearchStatusException(TransformMessages.getMessage((String)"Destination index [{0}] should refer to a single index", (Object[])new Object[]{destIndex}), RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    static class DestinationInSourceValidation
    implements SourceDestValidation {
        DestinationInSourceValidation() {
        }

        @Override
        public boolean isDeferrable() {
            return true;
        }

        @Override
        public void validate(TransformConfig config, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
            String destIndex = config.getDestination().getIndex();
            HashSet<String> concreteSourceIndexNames = new HashSet<String>();
            for (String src : config.getSource().getIndex()) {
                String[] concreteNames = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{src});
                if (Regex.simpleMatch((String)src, (String)destIndex)) {
                    throw new ElasticsearchStatusException(TransformMessages.getMessage((String)"Destination index [{0}] is included in source expression [{1}]", (Object[])new Object[]{destIndex, src}), RestStatus.BAD_REQUEST, new Object[0]);
                }
                concreteSourceIndexNames.addAll(Arrays.asList(concreteNames));
            }
            if (concreteSourceIndexNames.contains(destIndex)) {
                throw new ElasticsearchStatusException(TransformMessages.getMessage((String)"Destination index [{0}] is included in source expression [{1}]", (Object[])new Object[]{destIndex, Strings.arrayToCommaDelimitedString((Object[])config.getSource().getIndex())}), RestStatus.BAD_REQUEST, new Object[0]);
            }
            String[] concreteDest = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{destIndex});
            if (concreteDest.length > 0 && concreteSourceIndexNames.contains(concreteDest[0])) {
                throw new ElasticsearchStatusException(TransformMessages.getMessage((String)"Destination index [{0}] is included in source expression [{1}]", (Object[])new Object[]{concreteDest[0], Strings.arrayToCommaDelimitedString((Object[])concreteSourceIndexNames.toArray(new String[0]))}), RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    static class SourceMissingValidation
    implements SourceDestValidation {
        SourceMissingValidation() {
        }

        @Override
        public boolean isDeferrable() {
            return true;
        }

        @Override
        public void validate(TransformConfig config, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
            for (String src : config.getSource().getIndex()) {
                String[] concreteNames = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{src});
                if (concreteNames.length != 0) continue;
                throw new ElasticsearchStatusException(TransformMessages.getMessage((String)"Source index [{0}] does not exist", (Object[])new Object[]{src}), RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    static interface SourceDestValidation {
        public boolean isDeferrable();

        public void validate(TransformConfig var1, ClusterState var2, IndexNameExpressionResolver var3);
    }
}

