/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;

public final class TransformInternalIndex {
    public static final String DYNAMIC = "dynamic";
    public static final String PROPERTIES = "properties";
    public static final String TYPE = "type";
    public static final String ENABLED = "enabled";
    public static final String DATE = "date";
    public static final String TEXT = "text";
    public static final String FIELDS = "fields";
    public static final String RAW = "raw";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String LONG = "long";
    public static final String KEYWORD = "keyword";

    public static IndexTemplateMetaData getIndexTemplateMetaData() throws IOException {
        IndexTemplateMetaData transformTemplate = IndexTemplateMetaData.builder((String)".transform-internal-003").patterns(Collections.singletonList(".transform-internal-003")).version(Integer.valueOf(Version.CURRENT.id)).settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1")).putMapping("_doc", Strings.toString((XContentBuilder)TransformInternalIndex.mappings())).putAlias(AliasMetaData.builder((String)".data-frame-internal-3")).build();
        return transformTemplate;
    }

    public static IndexTemplateMetaData getAuditIndexTemplateMetaData() throws IOException {
        IndexTemplateMetaData transformTemplate = IndexTemplateMetaData.builder((String)".transform-notifications-000001").patterns(Collections.singletonList(".transform-notifications-*")).version(Integer.valueOf(Version.CURRENT.id)).settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1")).putMapping("_doc", Strings.toString((XContentBuilder)TransformInternalIndex.auditMappings())).putAlias(AliasMetaData.builder((String)".transform-notifications-read")).build();
        return transformTemplate;
    }

    private static XContentBuilder auditMappings() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        builder.startObject("_doc");
        TransformInternalIndex.addMetaInformation(builder);
        builder.field(DYNAMIC, "false");
        builder.startObject(PROPERTIES).startObject("transform_id").field(TYPE, KEYWORD).endObject().startObject(AbstractAuditMessage.LEVEL.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AbstractAuditMessage.MESSAGE.getPreferredName()).field(TYPE, TEXT).startObject(FIELDS).startObject(RAW).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(AbstractAuditMessage.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(AbstractAuditMessage.NODE_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().endObject();
        return builder;
    }

    public static XContentBuilder mappings() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        return TransformInternalIndex.mappings(builder);
    }

    public static XContentBuilder mappings(XContentBuilder builder) throws IOException {
        builder.startObject();
        builder.startObject("_doc");
        TransformInternalIndex.addMetaInformation(builder);
        builder.field(DYNAMIC, "false");
        builder.startObject(PROPERTIES);
        builder.startObject(TransformField.INDEX_DOC_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject();
        TransformInternalIndex.addTransformsConfigMappings(builder);
        TransformInternalIndex.addTransformStoredDocMappings(builder);
        TransformInternalIndex.addTransformCheckpointMappings(builder);
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static XContentBuilder addTransformStoredDocMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(TransformStoredDoc.STATE_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(TransformState.TASK_STATE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformState.INDEXER_STATE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformState.CURRENT_POSITION.getPreferredName()).field(ENABLED, false).endObject().startObject(TransformState.CHECKPOINT.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformState.REASON.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformState.PROGRESS.getPreferredName()).startObject(PROPERTIES).startObject(TransformProgress.TOTAL_DOCS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformProgress.DOCS_REMAINING.getPreferredName()).field(TYPE, LONG).endObject().startObject("percent_complete").field(TYPE, FLOAT).endObject().startObject(TransformProgress.DOCS_INDEXED.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformProgress.DOCS_PROCESSED.getPreferredName()).field(TYPE, LONG).endObject().endObject().endObject().endObject().endObject().startObject(TransformField.STATS_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(TransformIndexerStats.NUM_PAGES.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.NUM_INPUT_DOCUMENTS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.NUM_OUTPUT_DOCUMENTS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.NUM_INVOCATIONS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.INDEX_TIME_IN_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.SEARCH_TIME_IN_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.INDEX_TOTAL.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.SEARCH_TOTAL.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.SEARCH_FAILURES.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.INDEX_FAILURES.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(TransformIndexerStats.EXPONENTIAL_AVG_DOCUMENTS_INDEXED.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(TransformIndexerStats.EXPONENTIAL_AVG_DOCUMENTS_PROCESSED.getPreferredName()).field(TYPE, DOUBLE).endObject().endObject().endObject();
    }

    public static XContentBuilder addTransformsConfigMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(TransformField.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformField.SOURCE.getPreferredName()).startObject(PROPERTIES).startObject(SourceConfig.INDEX.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(SourceConfig.QUERY.getPreferredName()).field(ENABLED, "false").endObject().endObject().endObject().startObject(TransformField.DESTINATION.getPreferredName()).startObject(PROPERTIES).startObject(DestConfig.INDEX.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(TransformField.DESCRIPTION.getPreferredName()).field(TYPE, TEXT).endObject().startObject(TransformField.VERSION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformField.CREATE_TIME.getPreferredName()).field(TYPE, DATE).endObject();
    }

    private static XContentBuilder addTransformCheckpointMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(TransformField.TIMESTAMP_MILLIS.getPreferredName()).field(TYPE, DATE).endObject().startObject(TransformField.TIME_UPPER_BOUND_MILLIS.getPreferredName()).field(TYPE, DATE).endObject();
    }

    private static XContentBuilder addMetaInformation(XContentBuilder builder) throws IOException {
        return builder.startObject("_meta").field("version", (ToXContent)Version.CURRENT).endObject();
    }

    public static boolean haveLatestVersionedIndexTemplate(ClusterState state) {
        return state.getMetaData().getTemplates().containsKey((Object)".transform-internal-003");
    }

    public static void installLatestVersionedIndexTemplateIfRequired(ClusterService clusterService, Client client, ActionListener<Void> listener) {
        if (TransformInternalIndex.haveLatestVersionedIndexTemplate(clusterService.state())) {
            listener.onResponse(null);
            return;
        }
        try {
            IndexTemplateMetaData indexTemplateMetaData = TransformInternalIndex.getIndexTemplateMetaData();
            BytesArray jsonMappings = new BytesArray(((CompressedXContent)indexTemplateMetaData.mappings().get((Object)"_doc")).uncompressed());
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(".transform-internal-003").patterns(indexTemplateMetaData.patterns()).version(indexTemplateMetaData.version()).settings(indexTemplateMetaData.settings()).alias(new Alias(".data-frame-internal-3")).mapping("_doc", (Map)XContentHelper.convertToMap((BytesReference)jsonMappings, (boolean)true, (XContentType)XContentType.JSON).v2());
            ActionListener innerListener = ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0));
            ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"transform", (ActionRequest)request, (ActionListener)innerListener, (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).putTemplate(arg_0, arg_1));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    private TransformInternalIndex() {
    }
}

