/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.persistence;

import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public final class TransformIndex {
    private static final Logger logger = LogManager.getLogger(TransformIndex.class);
    public static final String DOC_TYPE = "_doc";
    private static final String PROPERTIES = "properties";
    private static final String TYPE = "type";
    private static final String META = "_meta";

    private TransformIndex() {
    }

    public static void createDestinationIndex(Client client, Clock clock, TransformConfig transformConfig, Map<String, String> mappings, ActionListener<Boolean> listener) {
        CreateIndexRequest request = new CreateIndexRequest(transformConfig.getDestination().getIndex());
        request.settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1"));
        request.mapping(DOC_TYPE, TransformIndex.createMappingXContent(mappings, transformConfig.getId(), clock));
        client.execute((ActionType)CreateIndexAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(createIndexResponse -> listener.onResponse((Object)true), e -> {
            String message = TransformMessages.getMessage((String)"Could not create destination index [{0}] for transform [{1}]", (Object[])new Object[]{transformConfig.getDestination().getIndex(), transformConfig.getId()});
            logger.error(message);
            listener.onFailure((Exception)new RuntimeException(message, (Throwable)e));
        }));
    }

    private static XContentBuilder createMappingXContent(Map<String, String> mappings, String id, Clock clock) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            builder.startObject(DOC_TYPE);
            TransformIndex.addProperties(builder, mappings);
            TransformIndex.addMetaData(builder, id, clock);
            builder.endObject();
            return builder.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static XContentBuilder addProperties(XContentBuilder builder, Map<String, String> mappings) throws IOException {
        builder.startObject(PROPERTIES);
        for (Map.Entry<String, String> field : mappings.entrySet()) {
            String fieldName = field.getKey();
            String fieldType = field.getValue();
            builder.startObject(fieldName);
            builder.field(TYPE, fieldType);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static XContentBuilder addMetaData(XContentBuilder builder, String id, Clock clock) throws IOException {
        return builder.startObject(META).field("created_by", "transform").startObject("_transform").field("creation_date_in_millis", clock.millis()).startObject(TransformField.VERSION.getPreferredName()).field("created", (ToXContent)Version.CURRENT).endObject().field("transform", id).endObject().endObject();
    }
}

