/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.checkpoint;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.xpack.core.transform.transforms.TimeSyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointException;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.transform.checkpoint.DefaultCheckpointProvider;
import org.elasticsearch.xpack.transform.checkpoint.TimeBasedCheckpointProvider;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;

public class TransformCheckpointService {
    private static final Logger logger = LogManager.getLogger(TransformCheckpointService.class);
    private final Client client;
    private final TransformConfigManager transformConfigManager;
    private final TransformAuditor transformAuditor;

    public TransformCheckpointService(Client client, TransformConfigManager transformConfigManager, TransformAuditor transformAuditor) {
        this.client = client;
        this.transformConfigManager = transformConfigManager;
        this.transformAuditor = transformAuditor;
    }

    public CheckpointProvider getCheckpointProvider(TransformConfig transformConfig) {
        if (transformConfig.getSyncConfig() instanceof TimeSyncConfig) {
            return new TimeBasedCheckpointProvider(this.client, this.transformConfigManager, this.transformAuditor, transformConfig);
        }
        return new DefaultCheckpointProvider(this.client, this.transformConfigManager, this.transformAuditor, transformConfig);
    }

    public void getCheckpointingInfo(String transformId, long lastCheckpointNumber, TransformIndexerPosition nextCheckpointPosition, TransformProgress nextCheckpointProgress, ActionListener<TransformCheckpointingInfo> listener) {
        this.transformConfigManager.getTransformConfiguration(transformId, (ActionListener<TransformConfig>)ActionListener.wrap(transformConfig -> this.getCheckpointProvider((TransformConfig)transformConfig).getCheckpointingInfo(lastCheckpointNumber, nextCheckpointPosition, nextCheckpointProgress, listener), transformError -> {
            logger.warn("Failed to retrieve configuration for transform [" + transformId + "]", (Throwable)transformError);
            listener.onFailure((Exception)((Object)new CheckpointException("Failed to retrieve configuration", (Throwable)transformError, new Object[0])));
        }));
    }
}

