/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointException;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;

public class DefaultCheckpointProvider
implements CheckpointProvider {
    private static final int AUDIT_CONCRETED_SOURCE_INDEX_CHANGES = 10;
    private static final Logger logger = LogManager.getLogger(DefaultCheckpointProvider.class);
    protected final Client client;
    protected final TransformConfigManager transformConfigManager;
    protected final TransformAuditor transformAuditor;
    protected final TransformConfig transformConfig;

    public DefaultCheckpointProvider(Client client, TransformConfigManager transformConfigManager, TransformAuditor transformAuditor, TransformConfig transformConfig) {
        this.client = client;
        this.transformConfigManager = transformConfigManager;
        this.transformAuditor = transformAuditor;
        this.transformConfig = transformConfig;
    }

    @Override
    public void sourceHasChanged(TransformCheckpoint lastCheckpoint, ActionListener<Boolean> listener) {
        listener.onResponse((Object)false);
    }

    @Override
    public void createNextCheckpoint(TransformCheckpoint lastCheckpoint, ActionListener<TransformCheckpoint> listener) {
        long timestamp = System.currentTimeMillis();
        long checkpoint = lastCheckpoint != null ? lastCheckpoint.getCheckpoint() + 1L : 1L;
        this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)ActionListener.wrap(checkpointsByIndex -> {
            this.reportSourceIndexChanges(lastCheckpoint != null ? lastCheckpoint.getIndicesCheckpoints().keySet() : Collections.emptySet(), checkpointsByIndex.keySet());
            listener.onResponse((Object)new TransformCheckpoint(this.transformConfig.getId(), timestamp, checkpoint, checkpointsByIndex, Long.valueOf(0L)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected void getIndexCheckpoints(ActionListener<Map<String, long[]>> listener) {
        GetIndexRequest getIndexRequest = (GetIndexRequest)((GetIndexRequest)new GetIndexRequest().indices(this.transformConfig.getSource().getIndex())).features(new GetIndexRequest.Feature[0]).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)GetIndexAction.INSTANCE, (ActionRequest)getIndexRequest, (ActionListener)ActionListener.wrap(getIndexResponse -> {
            HashSet<String> userIndices = getIndexResponse.getIndices() != null ? new HashSet<String>(Arrays.asList(getIndexResponse.getIndices())) : Collections.emptySet();
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(this.transformConfig.getSource().getIndex())).clear().indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN)), (ActionListener)ActionListener.wrap(response -> {
                if (response.getFailedShards() != 0) {
                    listener.onFailure((Exception)((Object)new CheckpointException("Source has [" + response.getFailedShards() + "] failed shards", new Object[0])));
                    return;
                }
                listener.onResponse(DefaultCheckpointProvider.extractIndexCheckPoints(response.getShards(), userIndices));
            }, e -> listener.onFailure((Exception)((Object)new CheckpointException("Failed to create checkpoint", (Throwable)e, new Object[0])))));
        }, e -> listener.onFailure((Exception)((Object)new CheckpointException("Failed to create checkpoint", (Throwable)e, new Object[0])))));
    }

    static Map<String, long[]> extractIndexCheckPoints(ShardStats[] shards, Set<String> userIndices) {
        TreeMap<String, TreeMap> checkpointsByIndex = new TreeMap<String, TreeMap>();
        for (ShardStats shard : shards) {
            long globalCheckpoint;
            String indexName2 = shard.getShardRouting().getIndexName();
            if (!userIndices.contains(indexName2)) continue;
            long l = globalCheckpoint = shard.getSeqNoStats() == null ? -1L : shard.getSeqNoStats().getGlobalCheckpoint();
            if (checkpointsByIndex.containsKey(indexName2)) {
                TreeMap checkpoints2 = (TreeMap)checkpointsByIndex.get(indexName2);
                if (checkpoints2.containsKey(shard.getShardRouting().getId()) && (Long)checkpoints2.get(shard.getShardRouting().getId()) >= globalCheckpoint) continue;
                checkpoints2.put(shard.getShardRouting().getId(), globalCheckpoint);
                continue;
            }
            checkpointsByIndex.put(indexName2, new TreeMap());
            ((TreeMap)checkpointsByIndex.get(indexName2)).put(shard.getShardRouting().getId(), globalCheckpoint);
        }
        if (logger.isDebugEnabled()) {
            HashSet<String> userIndicesClone = new HashSet<String>(userIndices);
            userIndicesClone.removeAll(checkpointsByIndex.keySet());
            if (!userIndicesClone.isEmpty()) {
                logger.debug("Original set of user indices contained more indexes [{}]", userIndicesClone);
            }
        }
        TreeMap<String, long[]> checkpointsByIndexReduced = new TreeMap<String, long[]>();
        checkpointsByIndex.forEach((indexName, checkpoints) -> checkpointsByIndexReduced.put((String)indexName, checkpoints.values().stream().mapToLong(l -> l).toArray()));
        return checkpointsByIndexReduced;
    }

    @Override
    public void getCheckpointingInfo(TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint, TransformIndexerPosition nextCheckpointPosition, TransformProgress nextCheckpointProgress, ActionListener<TransformCheckpointingInfo> listener) {
        TransformCheckpointingInfoBuilder checkpointingInfoBuilder = new TransformCheckpointingInfoBuilder();
        checkpointingInfoBuilder.setLastCheckpoint(lastCheckpoint).setNextCheckpoint(nextCheckpoint).setNextCheckpointPosition(nextCheckpointPosition).setNextCheckpointProgress(nextCheckpointProgress);
        long timestamp = System.currentTimeMillis();
        this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)ActionListener.wrap(checkpointsByIndex -> {
            checkpointingInfoBuilder.setSourceCheckpoint(new TransformCheckpoint(this.transformConfig.getId(), timestamp, -1L, checkpointsByIndex, Long.valueOf(0L)));
            listener.onResponse((Object)checkpointingInfoBuilder.build());
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void getCheckpointingInfo(long lastCheckpointNumber, TransformIndexerPosition nextCheckpointPosition, TransformProgress nextCheckpointProgress, ActionListener<TransformCheckpointingInfo> listener) {
        TransformCheckpointingInfoBuilder checkpointingInfoBuilder = new TransformCheckpointingInfoBuilder();
        checkpointingInfoBuilder.setNextCheckpointPosition(nextCheckpointPosition).setNextCheckpointProgress(nextCheckpointProgress);
        long timestamp = System.currentTimeMillis();
        ActionListener checkpointsByIndexListener = ActionListener.wrap(checkpointsByIndex -> {
            checkpointingInfoBuilder.setSourceCheckpoint(new TransformCheckpoint(this.transformConfig.getId(), timestamp, -1L, checkpointsByIndex, Long.valueOf(0L)));
            listener.onResponse((Object)checkpointingInfoBuilder.build());
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("Failed to retrieve source checkpoint for transform [{}]", (Object)this.transformConfig.getId()), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during source checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        ActionListener nextCheckpointListener = ActionListener.wrap(nextCheckpointObj -> {
            checkpointingInfoBuilder.setNextCheckpoint((TransformCheckpoint)nextCheckpointObj);
            this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)checkpointsByIndexListener);
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("Failed to retrieve next checkpoint [{}] for transform [{}]", (Object)(lastCheckpointNumber + 1L), (Object)this.transformConfig.getId()), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during next checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        ActionListener lastCheckpointListener = ActionListener.wrap(lastCheckpointObj -> {
            checkpointingInfoBuilder.lastCheckpoint = lastCheckpointObj;
            this.transformConfigManager.getTransformCheckpoint(this.transformConfig.getId(), lastCheckpointNumber + 1L, (ActionListener<TransformCheckpoint>)nextCheckpointListener);
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("Failed to retrieve last checkpoint [{}] for transform [{}]", (Object)lastCheckpointNumber, (Object)this.transformConfig.getId()), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during last checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        if (lastCheckpointNumber != 0L) {
            this.transformConfigManager.getTransformCheckpoint(this.transformConfig.getId(), lastCheckpointNumber, (ActionListener<TransformCheckpoint>)lastCheckpointListener);
        } else {
            this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)checkpointsByIndexListener);
        }
    }

    void reportSourceIndexChanges(Set<String> lastSourceIndexes, Set<String> newSourceIndexes) {
        if (newSourceIndexes.isEmpty() && !lastSourceIndexes.isEmpty()) {
            String message = "Source did not resolve to any open indexes";
            logger.warn("{} for transform [{}]", (Object)message, (Object)this.transformConfig.getId());
            this.transformAuditor.warning(this.transformConfig.getId(), message);
        } else {
            Set removedIndexes = Sets.difference(lastSourceIndexes, newSourceIndexes);
            Set addedIndexes = Sets.difference(newSourceIndexes, lastSourceIndexes);
            if (removedIndexes.size() + addedIndexes.size() > 10) {
                String message = "Source index resolve found more than 10 changes, [" + removedIndexes.size() + "] removed indexes, [" + addedIndexes.size() + "] new indexes";
                logger.debug("{} for transform [{}]", (Object)message, (Object)this.transformConfig.getId());
                this.transformAuditor.info(this.transformConfig.getId(), message);
            } else if (removedIndexes.size() + addedIndexes.size() > 0) {
                String message = "Source index resolve found changes, removedIndexes: " + removedIndexes + ", new indexes: " + addedIndexes;
                logger.debug("{} for transform [{}]", (Object)message, (Object)this.transformConfig.getId());
                this.transformAuditor.info(this.transformConfig.getId(), message);
            }
        }
    }

    private static class TransformCheckpointingInfoBuilder {
        private TransformIndexerPosition nextCheckpointPosition;
        private TransformProgress nextCheckpointProgress;
        private TransformCheckpoint lastCheckpoint;
        private TransformCheckpoint nextCheckpoint;
        private TransformCheckpoint sourceCheckpoint;

        TransformCheckpointingInfoBuilder() {
        }

        TransformCheckpointingInfo build() {
            if (this.lastCheckpoint == null) {
                this.lastCheckpoint = TransformCheckpoint.EMPTY;
            }
            if (this.nextCheckpoint == null) {
                this.nextCheckpoint = TransformCheckpoint.EMPTY;
            }
            if (this.sourceCheckpoint == null) {
                this.sourceCheckpoint = TransformCheckpoint.EMPTY;
            }
            long lastCheckpointNumber = this.lastCheckpoint.getCheckpoint() > 0L ? this.lastCheckpoint.getCheckpoint() : 0L;
            long nextCheckpointNumber = this.nextCheckpoint.getCheckpoint() > 0L ? this.nextCheckpoint.getCheckpoint() : 0L;
            return new TransformCheckpointingInfo(new TransformCheckpointStats(lastCheckpointNumber, null, null, this.lastCheckpoint.getTimestamp(), this.lastCheckpoint.getTimeUpperBound()), new TransformCheckpointStats(nextCheckpointNumber, this.nextCheckpointPosition, this.nextCheckpointProgress, this.nextCheckpoint.getTimestamp(), this.nextCheckpoint.getTimeUpperBound()), TransformCheckpoint.getBehind((TransformCheckpoint)this.lastCheckpoint, (TransformCheckpoint)this.sourceCheckpoint));
        }

        public TransformCheckpointingInfoBuilder setLastCheckpoint(TransformCheckpoint lastCheckpoint) {
            this.lastCheckpoint = lastCheckpoint;
            return this;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpoint(TransformCheckpoint nextCheckpoint) {
            this.nextCheckpoint = nextCheckpoint;
            return this;
        }

        public TransformCheckpointingInfoBuilder setSourceCheckpoint(TransformCheckpoint sourceCheckpoint) {
            this.sourceCheckpoint = sourceCheckpoint;
            return this;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpointProgress(TransformProgress nextCheckpointProgress) {
            this.nextCheckpointProgress = nextCheckpointProgress;
            return this;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpointPosition(TransformIndexerPosition nextCheckpointPosition) {
            this.nextCheckpointPosition = nextCheckpointPosition;
            return this;
        }
    }
}

