/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.io.IOException;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.transform.action.UpdateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;
import org.elasticsearch.xpack.transform.action.TransportPutTransformAction;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.SourceDestValidator;
import org.elasticsearch.xpack.transform.transforms.pivot.Pivot;

public class TransportUpdateTransformAction
extends TransportMasterNodeAction<UpdateTransformAction.Request, UpdateTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateTransformAction.class);
    private final XPackLicenseState licenseState;
    private final Client client;
    private final TransformConfigManager transformConfigManager;
    private final SecurityContext securityContext;
    private final TransformAuditor auditor;

    @Inject
    public TransportUpdateTransformAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, TransformConfigManager transformConfigManager, Client client, TransformAuditor auditor) {
        this("cluster:admin/transform/update", settings, transportService, threadPool, actionFilters, indexNameExpressionResolver, clusterService, licenseState, transformConfigManager, client, auditor);
    }

    protected TransportUpdateTransformAction(String name, Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, TransformConfigManager transformConfigManager, Client client, TransformAuditor auditor) {
        super(name, transportService, clusterService, threadPool, actionFilters, UpdateTransformAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.client = client;
        this.transformConfigManager = transformConfigManager;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.auditor = auditor;
    }

    protected String executor() {
        return "same";
    }

    protected UpdateTransformAction.Response read(StreamInput in) throws IOException {
        return new UpdateTransformAction.Response(in);
    }

    protected void masterOperation(UpdateTransformAction.Request request, ClusterState clusterState, ActionListener<UpdateTransformAction.Response> listener) {
        if (!this.licenseState.isTransformAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"transform"));
            return;
        }
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        Map<String, String> filteredHeaders = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        TransformConfigUpdate update = request.getUpdate();
        update.setHeaders(filteredHeaders);
        this.transformConfigManager.getTransformConfigurationForUpdate(request.getId(), (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(configAndVersion -> {
            TransformConfig config = (TransformConfig)configAndVersion.v1();
            if (update.isNoop(config)) {
                listener.onResponse((Object)new UpdateTransformAction.Response(config));
                return;
            }
            TransformConfig updatedConfig = update.apply(config);
            this.validateAndUpdateTransform(request, clusterState, updatedConfig, (SeqNoPrimaryTermAndIndex)configAndVersion.v2(), listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(UpdateTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void handlePrivsResponse(String username, UpdateTransformAction.Request request, TransformConfig config, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ClusterState clusterState, HasPrivilegesResponse privilegesResponse, ActionListener<UpdateTransformAction.Response> listener) {
        if (privilegesResponse.isCompleteMatch()) {
            this.updateTransform(request, config, seqNoPrimaryTermAndIndex, clusterState, listener);
        } else {
            List indices = privilegesResponse.getIndexPrivileges().stream().map(ResourcePrivileges::getResource).collect(Collectors.toList());
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot update transform [{}] because user {} lacks all the required permissions for indices: {}", (Object[])new Object[]{request.getId(), username, indices}));
        }
    }

    private void validateAndUpdateTransform(UpdateTransformAction.Request request, ClusterState clusterState, TransformConfig config, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ActionListener<UpdateTransformAction.Response> listener) {
        try {
            SourceDestValidator.validate(config, clusterState, this.indexNameExpressionResolver, request.isDeferValidation());
        }
        catch (ElasticsearchStatusException ex) {
            listener.onFailure((Exception)((Object)ex));
            return;
        }
        if (this.licenseState.isAuthAllowed() && !request.isDeferValidation()) {
            String username = this.securityContext.getUser().principal();
            HasPrivilegesRequest privRequest = TransportPutTransformAction.buildPrivilegeCheck(config, this.indexNameExpressionResolver, clusterState, username);
            ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, request, config, seqNoPrimaryTermAndIndex, clusterState, (HasPrivilegesResponse)r, listener), arg_0 -> listener.onFailure(arg_0));
            this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
        } else {
            this.updateTransform(request, config, seqNoPrimaryTermAndIndex, clusterState, listener);
        }
    }

    private void updateTransform(UpdateTransformAction.Request request, TransformConfig config, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ClusterState clusterState, ActionListener<UpdateTransformAction.Response> listener) {
        Pivot pivot = new Pivot(config.getPivotConfig());
        ActionListener putTransformConfigurationListener = ActionListener.wrap(putTransformConfigurationResult -> {
            this.auditor.info(config.getId(), "updated transform.");
            this.transformConfigManager.deleteOldTransformConfigurations(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                logger.trace("[{}] successfully deleted old transform configurations", (Object)request.getId());
                listener.onResponse((Object)new UpdateTransformAction.Response(config));
            }, e -> {
                logger.warn(LoggerMessageFormat.format((String)"[{}] failed deleting old transform configurations.", (String)request.getId(), (Object[])new Object[0]), (Throwable)e);
                listener.onResponse((Object)new UpdateTransformAction.Response(config));
            }));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener createDestinationListener = ActionListener.wrap(createDestResponse -> this.transformConfigManager.updateTransformConfiguration(config, seqNoPrimaryTermAndIndex, (ActionListener<Boolean>)putTransformConfigurationListener), arg_0 -> listener.onFailure(arg_0));
        ActionListener pivotValidationListener = ActionListener.wrap(validationResult -> {
            String[] dest = this.indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{config.getDestination().getIndex()});
            String[] src = this.indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), config.getSource().getIndex());
            if (PersistentTasksCustomMetaData.getTaskWithId((ClusterState)clusterState, (String)request.getId()) != null && dest.length == 0 && src.length > 0) {
                this.createDestination(pivot, config, (ActionListener<Void>)createDestinationListener);
            } else {
                createDestinationListener.onResponse(null);
            }
        }, validationException -> {
            if (validationException instanceof ElasticsearchStatusException) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate configuration", ((ElasticsearchStatusException)((Object)((Object)validationException))).status(), (Throwable)validationException, new Object[0])));
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate configuration", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)validationException, new Object[0])));
            }
        });
        try {
            pivot.validateConfig();
        }
        catch (ElasticsearchStatusException e) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate configuration", e.status(), (Throwable)e, new Object[0])));
            return;
        }
        catch (Exception e) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate configuration", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0])));
            return;
        }
        if (request.isDeferValidation()) {
            pivotValidationListener.onResponse((Object)true);
        } else {
            pivot.validateQuery(this.client, config.getSource(), (ActionListener<Boolean>)pivotValidationListener);
        }
    }

    private void createDestination(Pivot pivot, TransformConfig config, ActionListener<Void> listener) {
        ActionListener deduceMappingsListener = ActionListener.wrap(mappings -> TransformIndex.createDestinationIndex(this.client, Clock.systemUTC(), config, mappings, (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), deduceTargetMappingsException -> listener.onFailure((Exception)new RuntimeException("Failed to deduce dest mappings", (Throwable)deduceTargetMappingsException)));
        pivot.deduceMappings(this.client, config.getSource(), (ActionListener<Map<String, String>>)deduceMappingsListener);
    }
}

