/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.action.TransformNodes;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportStopTransformAction
extends TransportTasksAction<TransformTask, StopTransformAction.Request, StopTransformAction.Response, StopTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStopTransformAction.class);
    private final ThreadPool threadPool;
    private final TransformConfigManager transformConfigManager;
    private final PersistentTasksService persistentTasksService;
    private final Client client;

    @Inject
    public TransportStopTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, PersistentTasksService persistentTasksService, TransformConfigManager transformConfigManager, Client client) {
        this("cluster:admin/transform/stop", transportService, actionFilters, clusterService, threadPool, persistentTasksService, transformConfigManager, client);
    }

    protected TransportStopTransformAction(String name, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, PersistentTasksService persistentTasksService, TransformConfigManager transformConfigManager, Client client) {
        super(name, clusterService, transportService, actionFilters, StopTransformAction.Request::new, StopTransformAction.Response::new, StopTransformAction.Response::new, "same");
        this.threadPool = threadPool;
        this.transformConfigManager = transformConfigManager;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
    }

    static void validateTaskState(ClusterState state, List<String> transformIds, boolean isForce) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.metaData().custom("persistent_tasks");
        if (!isForce && tasks != null) {
            ArrayList<String> failedTasks = new ArrayList<String>();
            ArrayList<String> failedReasons = new ArrayList<String>();
            for (String transformId : transformIds) {
                PersistentTasksCustomMetaData.PersistentTask dfTask = tasks.getTask(transformId);
                if (dfTask == null || !(dfTask.getState() instanceof TransformState) || ((TransformState)dfTask.getState()).getTaskState() != TransformTaskState.FAILED) continue;
                failedTasks.add(transformId);
                failedReasons.add(((TransformState)dfTask.getState()).getReason());
            }
            if (!failedTasks.isEmpty()) {
                String msg = failedTasks.size() == 1 ? TransformMessages.getMessage((String)"Unable to stop transform [{0}] as it is in a failed state with reason [{1}]. Use force stop to stop the transform.", (Object[])new Object[]{failedTasks.get(0), failedReasons.get(0)}) : "Unable to stop transforms. The following transforms are in a failed state " + failedTasks + " with reasons " + failedReasons + ". Use force stop to stop the transforms.";
                throw new ElasticsearchStatusException(msg, RestStatus.CONFLICT, new Object[0]);
            }
        }
    }

    protected void doExecute(Task task, StopTransformAction.Request request, ActionListener<StopTransformAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException("no known master node"));
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopTransformAction.Response::new));
            }
        } else {
            ActionListener<StopTransformAction.Response> finalListener = request.waitForCompletion() ? this.waitForStopListener(request, listener) : listener;
            this.transformConfigManager.expandTransformIds(request.getId(), new PageParams(0, 10000), request.isAllowNoMatch(), (ActionListener<Tuple<Long, List<String>>>)ActionListener.wrap(hitsAndIds -> {
                TransportStopTransformAction.validateTaskState(state, (List)hitsAndIds.v2(), request.isForce());
                request.setExpandedIds(new HashSet((Collection)hitsAndIds.v2()));
                request.setNodes(TransformNodes.transformTaskNodes((List)hitsAndIds.v2(), state));
                super.doExecute(task, (BaseTasksRequest)request, finalListener);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    protected void taskOperation(StopTransformAction.Request request, TransformTask transformTask, ActionListener<StopTransformAction.Response> listener) {
        Set ids = request.getExpandedIds();
        if (ids == null) {
            listener.onFailure((Exception)new IllegalStateException("Request does not have expandedIds set"));
            return;
        }
        if (ids.contains(transformTask.getTransformId())) {
            try {
                transformTask.stop(request.isForce());
            }
            catch (ElasticsearchException ex) {
                listener.onFailure((Exception)((Object)ex));
                return;
            }
            listener.onResponse((Object)new StopTransformAction.Response(Boolean.TRUE.booleanValue()));
        } else {
            listener.onFailure((Exception)new RuntimeException("ID of transform task [" + transformTask.getTransformId() + "] does not match request's ID [" + request.getId() + "]"));
        }
    }

    protected StopTransformAction.Response newResponse(StopTransformAction.Request request, List<StopTransformAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty() || !failedNodeExceptions.isEmpty()) {
            return new StopTransformAction.Response(taskOperationFailures, failedNodeExceptions, false);
        }
        return new StopTransformAction.Response(tasks.stream().allMatch(StopTransformAction.Response::isAcknowledged));
    }

    private ActionListener<StopTransformAction.Response> waitForStopListener(StopTransformAction.Request request, ActionListener<StopTransformAction.Response> listener) {
        ActionListener onStopListener = ActionListener.wrap(waitResponse -> this.client.admin().indices().prepareRefresh(new String[]{".transform-internal-003"}).execute(ActionListener.wrap(r -> listener.onResponse(waitResponse), e -> {
            logger.info("Failed to refresh internal index after delete", (Throwable)e);
            listener.onResponse(waitResponse);
        })), arg_0 -> listener.onFailure(arg_0));
        return ActionListener.wrap(response -> {
            if (!response.getTaskFailures().isEmpty() || !response.getNodeFailures().isEmpty()) {
                RestStatus status = TransportStopTransformAction.firstNotOKStatus(response.getTaskFailures(), response.getNodeFailures());
                listener.onFailure((Exception)TransportStopTransformAction.buildException(response.getTaskFailures(), response.getNodeFailures(), status));
                return;
            }
            this.threadPool.generic().execute(() -> this.waitForTransformStopped(request.getExpandedIds(), request.getTimeout(), request.isForce(), (ActionListener<StopTransformAction.Response>)onStopListener));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    static ElasticsearchStatusException buildException(List<TaskOperationFailure> taskOperationFailures, List<ElasticsearchException> elasticsearchExceptions, RestStatus status) {
        List exceptions = Stream.concat(taskOperationFailures.stream().map(TaskOperationFailure::getCause), elasticsearchExceptions.stream()).collect(Collectors.toList());
        ElasticsearchStatusException elasticsearchStatusException = new ElasticsearchStatusException(((Exception)exceptions.get(0)).getMessage(), status, new Object[0]);
        for (int i = 1; i < exceptions.size(); ++i) {
            elasticsearchStatusException.addSuppressed((Throwable)exceptions.get(i));
        }
        return elasticsearchStatusException;
    }

    static RestStatus firstNotOKStatus(List<TaskOperationFailure> taskOperationFailures, List<ElasticsearchException> exceptions) {
        RestStatus status;
        block2: {
            ElasticsearchException exception;
            TaskOperationFailure taskOperationFailure;
            status = RestStatus.OK;
            Iterator<Object> iterator = taskOperationFailures.iterator();
            while (iterator.hasNext() && RestStatus.OK.equals((Object)(status = (taskOperationFailure = iterator.next()).getStatus()))) {
            }
            if (status != RestStatus.OK) break block2;
            iterator = exceptions.iterator();
            while (iterator.hasNext() && RestStatus.OK.equals((Object)(status = (exception = (ElasticsearchException)((Object)iterator.next())).status()))) {
            }
        }
        return status == RestStatus.OK ? RestStatus.INTERNAL_SERVER_ERROR : status;
    }

    private void waitForTransformStopped(Set<String> persistentTaskIds, TimeValue timeout, boolean force, ActionListener<StopTransformAction.Response> listener) {
        ConcurrentHashMap exceptions = new ConcurrentHashMap();
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetaData -> {
            if (persistentTasksCustomMetaData == null) {
                return true;
            }
            for (String persistentTaskId : persistentTaskIds) {
                PersistentTasksCustomMetaData.PersistentTask transformsTask = persistentTasksCustomMetaData.getTask(persistentTaskId);
                if (transformsTask == null || exceptions.containsKey(persistentTaskId)) continue;
                TransformState taskState = (TransformState)transformsTask.getState();
                if (!force && taskState != null && taskState.getTaskState() == TransformTaskState.FAILED) {
                    exceptions.put(persistentTaskId, new ElasticsearchStatusException(TransformMessages.getMessage((String)"Unable to stop transform [{0}] as it is in a failed state with reason [{1}]. Use force stop to stop the transform.", (Object[])new Object[]{persistentTaskId, taskState.getReason()}), RestStatus.CONFLICT, new Object[0]));
                    return persistentTasksCustomMetaData.tasks().stream().allMatch(p -> exceptions.containsKey(p.getId()));
                }
                return false;
            }
            return true;
        }, timeout, ActionListener.wrap(r -> {
            if (exceptions.isEmpty()) {
                listener.onResponse((Object)new StopTransformAction.Response(Boolean.TRUE.booleanValue()));
                return;
            }
            if (persistentTaskIds.size() == 1) {
                listener.onFailure((Exception)exceptions.get(persistentTaskIds.iterator().next()));
                return;
            }
            HashSet stoppedTasks = new HashSet(persistentTaskIds);
            stoppedTasks.removeAll(exceptions.keySet());
            String message = stoppedTasks.isEmpty() ? "Could not stop any of the tasks as all were failed. Use force stop to stop the transforms." : LoggerMessageFormat.format((String)"Successfully stopped [{}] transforms. Could not stop the transforms {} as they were failed. Use force stop to stop the transforms.", (Object[])new Object[]{stoppedTasks.size(), exceptions.keySet()});
            listener.onFailure((Exception)new ElasticsearchStatusException(message, RestStatus.CONFLICT, new Object[0]));
        }, e -> {
            if (e instanceof IllegalStateException && e.getMessage().startsWith("Timed out")) {
                PersistentTasksCustomMetaData persistentTasksCustomMetaData = (PersistentTasksCustomMetaData)this.clusterService.state().metaData().custom("persistent_tasks");
                if (persistentTasksCustomMetaData == null) {
                    listener.onResponse((Object)new StopTransformAction.Response(Boolean.TRUE.booleanValue()));
                    return;
                }
                HashSet<String> stillRunningTasks = new HashSet<String>();
                for (String persistentTaskId : persistentTaskIds) {
                    if (persistentTasksCustomMetaData.getTask(persistentTaskId) == null) continue;
                    stillRunningTasks.add(persistentTaskId);
                }
                if (stillRunningTasks.isEmpty()) {
                    listener.onResponse((Object)new StopTransformAction.Response(Boolean.TRUE.booleanValue()));
                    return;
                }
                StringBuilder message = new StringBuilder();
                if (persistentTaskIds.size() - stillRunningTasks.size() - exceptions.size() > 0) {
                    message.append("Successfully stopped [");
                    message.append(persistentTaskIds.size() - stillRunningTasks.size() - exceptions.size());
                    message.append("] transforms. ");
                }
                if (exceptions.size() > 0) {
                    message.append("Could not stop the transforms ");
                    message.append(exceptions.keySet());
                    message.append(" as they were failed. Use force stop to stop the transforms. ");
                }
                if (stillRunningTasks.size() > 0) {
                    message.append("Could not stop the transforms ");
                    message.append(stillRunningTasks);
                    message.append(" as they timed out.");
                }
                listener.onFailure((Exception)new ElasticsearchStatusException(message.toString(), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                return;
            }
            listener.onFailure(e);
        }));
    }
}

