/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.SimulatePipelineAction;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.PreviewTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.transform.transforms.pivot.AggregationResultUtils;
import org.elasticsearch.xpack.transform.transforms.pivot.Pivot;

public class TransportPreviewTransformAction
extends HandledTransportAction<PreviewTransformAction.Request, PreviewTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPreviewTransformAction.class);
    private static final int NUMBER_OF_PREVIEW_BUCKETS = 100;
    private final XPackLicenseState licenseState;
    private final Client client;
    private final ThreadPool threadPool;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ClusterService clusterService;

    @Inject
    public TransportPreviewTransformAction(TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool, XPackLicenseState licenseState, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        this("cluster:admin/transform/preview", transportService, actionFilters, client, threadPool, licenseState, indexNameExpressionResolver, clusterService);
    }

    protected TransportPreviewTransformAction(String name, TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool, XPackLicenseState licenseState, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        super(name, transportService, actionFilters, PreviewTransformAction.Request::new);
        this.licenseState = licenseState;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, PreviewTransformAction.Request request, ActionListener<PreviewTransformAction.Response> listener) {
        if (!this.licenseState.isTransformAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"transform"));
            return;
        }
        ClusterState clusterState = this.clusterService.state();
        TransformConfig config = request.getConfig();
        for (String src : config.getSource().getIndex()) {
            String[] concreteNames = this.indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{src});
            if (concreteNames.length != 0) continue;
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Source index [{0}] does not exist", (Object[])new Object[]{src}), RestStatus.BAD_REQUEST, new Object[0])));
            return;
        }
        Pivot pivot = new Pivot(config.getPivotConfig());
        try {
            pivot.validateConfig();
        }
        catch (ElasticsearchStatusException e) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate configuration", e.status(), (Throwable)e, new Object[0])));
            return;
        }
        catch (Exception e) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate configuration", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0])));
            return;
        }
        this.getPreview(pivot, config.getSource(), config.getDestination().getPipeline(), config.getDestination().getIndex(), listener);
    }

    private void getPreview(Pivot pivot, SourceConfig source, String pipeline, String dest, ActionListener<PreviewTransformAction.Response> listener) {
        PreviewTransformAction.Response previewResponse = new PreviewTransformAction.Response();
        ActionListener pipelineResponseActionListener = ActionListener.wrap(simulatePipelineResponse -> {
            ArrayList<Map> response = new ArrayList<Map>(simulatePipelineResponse.getResults().size());
            for (SimulateDocumentResult simulateDocumentResult : simulatePipelineResponse.getResults()) {
                XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                try {
                    XContentBuilder content = simulateDocumentResult.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                    Map tempMap = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)content), (boolean)true, (XContentType)XContentType.JSON).v2();
                    response.add((Map)XContentMapValues.extractValue((String)"doc._source", (Map)tempMap));
                }
                finally {
                    if (xContentBuilder == null) continue;
                    xContentBuilder.close();
                }
            }
            previewResponse.setDocs(response);
            listener.onResponse((Object)previewResponse);
        }, arg_0 -> listener.onFailure(arg_0));
        pivot.deduceMappings(this.client, source, (ActionListener<Map<String, String>>)ActionListener.wrap(deducedMappings -> {
            previewResponse.setMappingsFromStringMap(deducedMappings);
            ClientHelper.executeWithHeadersAsync((Map)this.threadPool.getThreadContext().getHeaders(), (String)"transform", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)pivot.buildSearchRequest(source, null, 100), (ActionListener)ActionListener.wrap(r -> {
                block10: {
                    try {
                        Aggregations aggregations = r.getAggregations();
                        if (aggregations == null) {
                            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Source indices have been deleted or closed.", RestStatus.BAD_REQUEST, new Object[0])));
                            return;
                        }
                        CompositeAggregation agg = (CompositeAggregation)aggregations.get("_transform");
                        TransformIndexerStats stats = new TransformIndexerStats();
                        if (pipeline == null) {
                            List results = pivot.extractResults(agg, (Map<String, String>)deducedMappings, stats).peek(doc -> doc.keySet().removeIf(k -> k.startsWith("_"))).collect(Collectors.toList());
                            previewResponse.setDocs(results);
                            listener.onResponse((Object)previewResponse);
                            break block10;
                        }
                        List results = pivot.extractResults(agg, (Map<String, String>)deducedMappings, stats).map(doc -> {
                            HashMap<String, Object> src = new HashMap<String, Object>();
                            String id = (String)doc.get(TransformField.DOCUMENT_ID_FIELD);
                            doc.keySet().removeIf(k -> k.startsWith("_"));
                            src.put("_source", doc);
                            src.put("_id", id);
                            src.put("_index", dest);
                            return src;
                        }).collect(Collectors.toList());
                        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                            builder.startObject();
                            builder.field("docs", results);
                            builder.endObject();
                            SimulatePipelineRequest pipelineRequest = new SimulatePipelineRequest(BytesReference.bytes((XContentBuilder)builder), XContentType.JSON);
                            pipelineRequest.setId(pipeline);
                            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)SimulatePipelineAction.INSTANCE, (ActionRequest)pipelineRequest, (ActionListener)pipelineResponseActionListener);
                        }
                    }
                    catch (AggregationResultUtils.AggregationExtractionException extractionException) {
                        listener.onFailure((Exception)((Object)new ElasticsearchStatusException(extractionException.getMessage(), RestStatus.BAD_REQUEST, new Object[0])));
                    }
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

