/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.action.GetTransformStatsAction;
import org.elasticsearch.xpack.core.transform.transforms.NodeAttributes;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.action.TransformNodes;
import org.elasticsearch.xpack.transform.checkpoint.TransformCheckpointService;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportGetTransformStatsAction
extends TransportTasksAction<TransformTask, GetTransformStatsAction.Request, GetTransformStatsAction.Response, GetTransformStatsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetTransformStatsAction.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformCheckpointService transformCheckpointService;

    @Inject
    public TransportGetTransformStatsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, TransformConfigManager transformConfigManager, TransformCheckpointService transformsCheckpointService) {
        this("cluster:monitor/transform/stats/get", transportService, actionFilters, clusterService, transformConfigManager, transformsCheckpointService);
    }

    protected TransportGetTransformStatsAction(String name, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, TransformConfigManager transformsConfigManager, TransformCheckpointService transformsCheckpointService) {
        super(name, clusterService, transportService, actionFilters, GetTransformStatsAction.Request::new, GetTransformStatsAction.Response::new, GetTransformStatsAction.Response::new, "same");
        this.transformConfigManager = transformsConfigManager;
        this.transformCheckpointService = transformsCheckpointService;
    }

    protected GetTransformStatsAction.Response newResponse(GetTransformStatsAction.Request request, List<GetTransformStatsAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        List responses = tasks.stream().flatMap(r -> r.getTransformsStats().stream()).sorted(Comparator.comparing(TransformStats::getId)).collect(Collectors.toList());
        ArrayList<FailedNodeException> allFailedNodeExceptions = new ArrayList<FailedNodeException>(failedNodeExceptions);
        allFailedNodeExceptions.addAll(tasks.stream().flatMap(r -> r.getNodeFailures().stream()).collect(Collectors.toList()));
        return new GetTransformStatsAction.Response(responses, (long)responses.size(), taskOperationFailures, allFailedNodeExceptions);
    }

    protected void taskOperation(GetTransformStatsAction.Request request, TransformTask task, ActionListener<GetTransformStatsAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        String nodeId = state.nodes().getLocalNode().getId();
        if (!task.isCancelled()) {
            TransformState transformState = task.getState();
            task.getCheckpointingInfo(this.transformCheckpointService, (ActionListener<TransformCheckpointingInfo>)ActionListener.wrap(checkpointingInfo -> listener.onResponse((Object)new GetTransformStatsAction.Response(Collections.singletonList(new TransformStats(task.getTransformId(), TransformStats.State.fromComponents((TransformTaskState)transformState.getTaskState(), (IndexerState)transformState.getIndexerState()), transformState.getReason(), null, task.getStats(), checkpointingInfo)), 1L)), e -> {
                logger.warn("Failed to retrieve checkpointing info for transform [" + task.getTransformId() + "]", (Throwable)e);
                listener.onResponse((Object)new GetTransformStatsAction.Response(Collections.singletonList(new TransformStats(task.getTransformId(), TransformStats.State.fromComponents((TransformTaskState)transformState.getTaskState(), (IndexerState)transformState.getIndexerState()), transformState.getReason(), null, task.getStats(), TransformCheckpointingInfo.EMPTY)), 1L, Collections.emptyList(), Collections.singletonList(new FailedNodeException(nodeId, "Failed to retrieve checkpointing info", (Throwable)e))));
            }));
        } else {
            listener.onResponse((Object)new GetTransformStatsAction.Response(Collections.emptyList(), 0L));
        }
    }

    protected void doExecute(Task task, GetTransformStatsAction.Request request, ActionListener<GetTransformStatsAction.Response> finalListener) {
        this.transformConfigManager.expandTransformIds(request.getId(), request.getPageParams(), request.isAllowNoMatch(), (ActionListener<Tuple<Long, List<String>>>)ActionListener.wrap(hitsAndIds -> {
            request.setExpandedIds((List)hitsAndIds.v2());
            ClusterState state = this.clusterService.state();
            request.setNodes(TransformNodes.transformTaskNodes((List)hitsAndIds.v2(), state));
            super.doExecute(task, (BaseTasksRequest)request, ActionListener.wrap(response -> {
                PersistentTasksCustomMetaData tasksInProgress = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
                if (tasksInProgress != null) {
                    response.getTransformsStats().forEach(dtsasi -> TransportGetTransformStatsAction.setNodeAttributes(dtsasi, tasksInProgress, state));
                }
                this.collectStatsForTransformsWithoutTasks(request, (GetTransformStatsAction.Response)response, (ActionListener<GetTransformStatsAction.Response>)ActionListener.wrap(finalResponse -> finalListener.onResponse((Object)new GetTransformStatsAction.Response(finalResponse.getTransformsStats(), ((Long)hitsAndIds.v1()).longValue(), finalResponse.getTaskFailures(), finalResponse.getNodeFailures())), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
            }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
        }, e -> {
            if (e instanceof ResourceNotFoundException) {
                finalListener.onResponse((Object)new GetTransformStatsAction.Response(Collections.emptyList(), 0L));
            } else {
                finalListener.onFailure(e);
            }
        }));
    }

    private static void setNodeAttributes(TransformStats transformStats, PersistentTasksCustomMetaData persistentTasksCustomMetaData, ClusterState state) {
        PersistentTasksCustomMetaData.PersistentTask pTask = persistentTasksCustomMetaData.getTask(transformStats.getId());
        if (pTask != null) {
            transformStats.setNode(NodeAttributes.fromDiscoveryNode((DiscoveryNode)state.nodes().get(pTask.getExecutorNode())));
        }
    }

    private void collectStatsForTransformsWithoutTasks(GetTransformStatsAction.Request request, GetTransformStatsAction.Response response, ActionListener<GetTransformStatsAction.Response> listener) {
        if (request.getExpandedIds().size() == response.getTransformsStats().size()) {
            listener.onResponse((Object)response);
            return;
        }
        HashSet<String> transformsWithoutTasks = new HashSet<String>(request.getExpandedIds());
        transformsWithoutTasks.removeAll(response.getTransformsStats().stream().map(TransformStats::getId).collect(Collectors.toList()));
        assert (transformsWithoutTasks.size() <= 1000);
        ActionListener searchStatsListener = ActionListener.wrap(statsForTransformsWithoutTasks -> {
            List allStateAndStats = response.getTransformsStats();
            this.addCheckpointingInfoForTransformsWithoutTasks(allStateAndStats, (List<TransformStoredDoc>)statsForTransformsWithoutTasks, (ActionListener<Void>)ActionListener.wrap(aVoid -> {
                transformsWithoutTasks.removeAll(statsForTransformsWithoutTasks.stream().map(TransformStoredDoc::getId).collect(Collectors.toSet()));
                transformsWithoutTasks.forEach(transformId -> allStateAndStats.add(TransformStats.initialStats((String)transformId)));
                allStateAndStats.sort(Comparator.comparing(TransformStats::getId));
                listener.onResponse((Object)new GetTransformStatsAction.Response(allStateAndStats, (long)allStateAndStats.size(), response.getTaskFailures(), response.getNodeFailures()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)response);
            } else {
                listener.onFailure(e);
            }
        });
        this.transformConfigManager.getTransformStoredDoc(transformsWithoutTasks, (ActionListener<List<TransformStoredDoc>>)searchStatsListener);
    }

    private void populateSingleStoppedTransformStat(TransformStoredDoc transform, ActionListener<TransformCheckpointingInfo> listener) {
        this.transformCheckpointService.getCheckpointingInfo(transform.getId(), transform.getTransformState().getCheckpoint(), transform.getTransformState().getPosition(), transform.getTransformState().getProgress(), (ActionListener<TransformCheckpointingInfo>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            logger.warn("Failed to retrieve checkpointing info for transform [" + transform.getId() + "]", (Throwable)e);
            listener.onResponse((Object)TransformCheckpointingInfo.EMPTY);
        }));
    }

    private void addCheckpointingInfoForTransformsWithoutTasks(List<TransformStats> allStateAndStats, List<TransformStoredDoc> statsForTransformsWithoutTasks, ActionListener<Void> listener) {
        if (statsForTransformsWithoutTasks.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        AtomicInteger numberRemaining = new AtomicInteger(statsForTransformsWithoutTasks.size());
        AtomicBoolean isExceptionReported = new AtomicBoolean(false);
        statsForTransformsWithoutTasks.forEach(stat -> this.populateSingleStoppedTransformStat((TransformStoredDoc)stat, (ActionListener<TransformCheckpointingInfo>)ActionListener.wrap(checkpointingInfo -> {
            List list = allStateAndStats;
            synchronized (list) {
                allStateAndStats.add(new TransformStats(stat.getId(), TransformStats.State.STOPPED, null, null, stat.getTransformStats(), checkpointingInfo));
            }
            if (numberRemaining.decrementAndGet() == 0) {
                listener.onResponse(null);
            }
        }, e -> {
            if (isExceptionReported.compareAndSet(false, true)) {
                listener.onFailure(e);
            }
        })));
    }
}

