/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;

public final class TransformNodes {
    private TransformNodes() {
    }

    public static String[] transformTaskNodes(List<String> transformIds, ClusterState clusterState) {
        HashSet<String> executorNodes = new HashSet<String>();
        PersistentTasksCustomMetaData tasksMetaData = PersistentTasksCustomMetaData.getPersistentTasksCustomMetaData((ClusterState)clusterState);
        if (tasksMetaData != null) {
            HashSet<String> transformIdsSet = new HashSet<String>(transformIds);
            Collection tasks = tasksMetaData.findTasks("data_frame/transforms", t -> transformIdsSet.contains(t.getId()));
            for (PersistentTasksCustomMetaData.PersistentTask task : tasks) {
                executorNodes.add(task.getExecutorNode());
            }
        }
        return executorNodes.toArray(new String[0]);
    }
}

