/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.transform.TransformFeatureSetUsage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;

public class TransformFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final Client client;
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;
    private static final Logger logger = LogManager.getLogger(TransformFeatureSet.class);
    public static final String[] PROVIDED_STATS = new String[]{TransformIndexerStats.NUM_PAGES.getPreferredName(), TransformIndexerStats.NUM_INPUT_DOCUMENTS.getPreferredName(), TransformIndexerStats.NUM_OUTPUT_DOCUMENTS.getPreferredName(), TransformIndexerStats.NUM_INVOCATIONS.getPreferredName(), TransformIndexerStats.INDEX_TIME_IN_MS.getPreferredName(), TransformIndexerStats.SEARCH_TIME_IN_MS.getPreferredName(), TransformIndexerStats.INDEX_TOTAL.getPreferredName(), TransformIndexerStats.SEARCH_TOTAL.getPreferredName(), TransformIndexerStats.INDEX_FAILURES.getPreferredName(), TransformIndexerStats.SEARCH_FAILURES.getPreferredName()};

    @Inject
    public TransformFeatureSet(Settings settings, ClusterService clusterService, Client client, @Nullable XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.TRANSFORM_ENABLED.get(settings);
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.licenseState = licenseState;
    }

    public String name() {
        return "transform";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isTransformAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        if (!this.enabled) {
            listener.onResponse((Object)new TransformFeatureSetUsage(this.available(), this.enabled(), Collections.emptyMap(), new TransformIndexerStats()));
            return;
        }
        PersistentTasksCustomMetaData taskMetadata = PersistentTasksCustomMetaData.getPersistentTasksCustomMetaData((ClusterState)this.clusterService.state());
        List<PersistentTasksCustomMetaData.PersistentTask> transformTasks = taskMetadata == null ? Collections.emptyList() : taskMetadata.findTasks("data_frame/transforms", t -> true);
        int taskCount = transformTasks.size();
        HashMap<String, Long> transformsCountByState = new HashMap<String, Long>();
        for (PersistentTasksCustomMetaData.PersistentTask transformTask : transformTasks) {
            TransformState state = (TransformState)transformTask.getState();
            transformsCountByState.merge(state.getTaskState().value(), 1L, Long::sum);
        }
        ActionListener totalStatsListener = ActionListener.wrap(statSummations -> listener.onResponse((Object)new TransformFeatureSetUsage(this.available(), this.enabled(), transformsCountByState, statSummations)), arg_0 -> listener.onFailure(arg_0));
        ActionListener totalTransformCountListener = ActionListener.wrap(transformCountSuccess -> {
            long totalTransforms;
            if (transformCountSuccess.getShardFailures().length > 0) {
                logger.error("total transform count search returned shard failures: {}", (Object)Arrays.toString(transformCountSuccess.getShardFailures()));
            }
            if ((totalTransforms = transformCountSuccess.getHits().getTotalHits().value) == 0L) {
                listener.onResponse((Object)new TransformFeatureSetUsage(this.available(), this.enabled(), transformsCountByState, new TransformIndexerStats()));
                return;
            }
            transformsCountByState.merge(TransformTaskState.STOPPED.value(), totalTransforms - (long)taskCount, Long::sum);
            TransformFeatureSet.getStatisticSummations(this.client, (ActionListener<TransformIndexerStats>)totalStatsListener);
        }, transformCountFailure -> {
            if (transformCountFailure instanceof ResourceNotFoundException) {
                TransformFeatureSet.getStatisticSummations(this.client, (ActionListener<TransformIndexerStats>)totalStatsListener);
            } else {
                listener.onFailure(transformCountFailure);
            }
        });
        SearchRequest totalTransformCount = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*"}).setTrackTotalHits(true).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config")))).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"transform", (ActionRequest)totalTransformCount, (ActionListener)totalTransformCountListener, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    static TransformIndexerStats parseSearchAggs(SearchResponse searchResponse) {
        ArrayList<Long> statisticsList = new ArrayList<Long>(PROVIDED_STATS.length);
        for (String statName : PROVIDED_STATS) {
            Aggregation agg = searchResponse.getAggregations().get(statName);
            if (agg instanceof NumericMetricsAggregation.SingleValue) {
                statisticsList.add((long)((NumericMetricsAggregation.SingleValue)agg).value());
                continue;
            }
            statisticsList.add(0L);
        }
        return new TransformIndexerStats(((Long)statisticsList.get(0)).longValue(), ((Long)statisticsList.get(1)).longValue(), ((Long)statisticsList.get(2)).longValue(), ((Long)statisticsList.get(3)).longValue(), ((Long)statisticsList.get(4)).longValue(), ((Long)statisticsList.get(5)).longValue(), ((Long)statisticsList.get(6)).longValue(), ((Long)statisticsList.get(7)).longValue(), ((Long)statisticsList.get(8)).longValue(), ((Long)statisticsList.get(9)).longValue());
    }

    static void getStatisticSummations(Client client, ActionListener<TransformIndexerStats> statsListener) {
        ConstantScoreQueryBuilder queryBuilder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_state_and_stats")));
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setSize(0).setQuery((QueryBuilder)queryBuilder);
        String path = TransformField.STATS_FIELD.getPreferredName() + ".";
        for (String statName : PROVIDED_STATS) {
            requestBuilder.addAggregation((AggregationBuilder)AggregationBuilders.sum((String)statName).field(path + statName));
        }
        ActionListener getStatisticSummationsListener = ActionListener.wrap(searchResponse -> {
            if (searchResponse.getShardFailures().length > 0) {
                logger.error("statistics summations search returned shard failures: {}", (Object)Arrays.toString(searchResponse.getShardFailures()));
            }
            statsListener.onResponse((Object)TransformFeatureSet.parseSearchAggs(searchResponse));
        }, failure -> {
            if (failure instanceof ResourceNotFoundException) {
                statsListener.onResponse((Object)new TransformIndexerStats());
            } else {
                statsListener.onFailure(failure);
            }
        });
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"transform", (ActionRequest)((SearchRequest)requestBuilder.request()), (ActionListener)getStatisticSummationsListener, (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }
}

