/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.core.transform.TransformNamedXContentProvider;
import org.elasticsearch.xpack.core.transform.action.DeleteTransformAction;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.action.GetTransformStatsAction;
import org.elasticsearch.xpack.core.transform.action.PreviewTransformAction;
import org.elasticsearch.xpack.core.transform.action.PutTransformAction;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.core.transform.action.UpdateTransformAction;
import org.elasticsearch.xpack.core.transform.action.compat.DeleteTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.GetTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.GetTransformStatsActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.PreviewTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.PutTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.StartTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.StopTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.UpdateTransformActionDeprecated;
import org.elasticsearch.xpack.transform.TransformClusterStateListener;
import org.elasticsearch.xpack.transform.TransformFeatureSet;
import org.elasticsearch.xpack.transform.action.TransportDeleteTransformAction;
import org.elasticsearch.xpack.transform.action.TransportGetTransformAction;
import org.elasticsearch.xpack.transform.action.TransportGetTransformStatsAction;
import org.elasticsearch.xpack.transform.action.TransportPreviewTransformAction;
import org.elasticsearch.xpack.transform.action.TransportPutTransformAction;
import org.elasticsearch.xpack.transform.action.TransportStartTransformAction;
import org.elasticsearch.xpack.transform.action.TransportStopTransformAction;
import org.elasticsearch.xpack.transform.action.TransportUpdateTransformAction;
import org.elasticsearch.xpack.transform.action.compat.TransportDeleteTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportGetTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportGetTransformStatsActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportPreviewTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportPutTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportStartTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportStopTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportUpdateTransformActionDeprecated;
import org.elasticsearch.xpack.transform.checkpoint.TransformCheckpointService;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;
import org.elasticsearch.xpack.transform.rest.action.RestDeleteTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestGetTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestGetTransformStatsAction;
import org.elasticsearch.xpack.transform.rest.action.RestPreviewTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestPutTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestStartTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestStopTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestUpdateTransformAction;
import org.elasticsearch.xpack.transform.rest.action.compat.RestDeleteTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestGetTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestGetTransformStatsActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestPreviewTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestPutTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestStartTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestStopTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestUpdateTransformActionDeprecated;
import org.elasticsearch.xpack.transform.transforms.TransformPersistentTasksExecutor;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class Transform
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin {
    public static final String NAME = "transform";
    public static final String TASK_THREAD_POOL_NAME = "transform_indexing";
    private static final Logger logger = LogManager.getLogger(Transform.class);
    private final boolean enabled;
    private final Settings settings;
    private final boolean transportClientMode;
    private final SetOnce<TransformConfigManager> transformConfigManager = new SetOnce();
    private final SetOnce<TransformAuditor> transformAuditor = new SetOnce();
    private final SetOnce<TransformCheckpointService> transformCheckpointService = new SetOnce();
    private final SetOnce<SchedulerEngine> schedulerEngine = new SetOnce();

    public Transform(Settings settings) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.TRANSFORM_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, TransformFeatureSet.class));
        return modules;
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestPutTransformAction(restController), new RestStartTransformAction(restController), new RestStopTransformAction(restController), new RestDeleteTransformAction(restController), new RestGetTransformAction(restController), new RestGetTransformStatsAction(restController), new RestPreviewTransformAction(restController), new RestUpdateTransformAction(restController), new RestPutTransformActionDeprecated(restController), new RestStartTransformActionDeprecated(restController), new RestStopTransformActionDeprecated(restController), new RestDeleteTransformActionDeprecated(restController), new RestGetTransformActionDeprecated(restController), new RestGetTransformStatsActionDeprecated(restController), new RestPreviewTransformActionDeprecated(restController), new RestUpdateTransformActionDeprecated(restController)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutTransformAction.INSTANCE, TransportPutTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartTransformAction.INSTANCE, TransportStartTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopTransformAction.INSTANCE, TransportStopTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteTransformAction.INSTANCE, TransportDeleteTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTransformAction.INSTANCE, TransportGetTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTransformStatsAction.INSTANCE, TransportGetTransformStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PreviewTransformAction.INSTANCE, TransportPreviewTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateTransformAction.INSTANCE, TransportUpdateTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutTransformActionDeprecated.INSTANCE, TransportPutTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartTransformActionDeprecated.INSTANCE, TransportStartTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopTransformActionDeprecated.INSTANCE, TransportStopTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteTransformActionDeprecated.INSTANCE, TransportDeleteTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTransformActionDeprecated.INSTANCE, TransportGetTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTransformStatsActionDeprecated.INSTANCE, TransportGetTransformStatsActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PreviewTransformActionDeprecated.INSTANCE, TransportPreviewTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateTransformActionDeprecated.INSTANCE, TransportUpdateTransformActionDeprecated.class, new Class[0]));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        FixedExecutorBuilder indexing = new FixedExecutorBuilder(settings, TASK_THREAD_POOL_NAME, 4, 4, "transform.task_thread_pool");
        return Collections.singletonList(indexing);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        this.transformAuditor.set((Object)new TransformAuditor(client, clusterService.getNodeName()));
        this.transformConfigManager.set((Object)new TransformConfigManager(client, xContentRegistry));
        this.transformCheckpointService.set((Object)new TransformCheckpointService(client, (TransformConfigManager)this.transformConfigManager.get(), (TransformAuditor)((Object)this.transformAuditor.get())));
        return Arrays.asList(this.transformConfigManager.get(), this.transformAuditor.get(), this.transformCheckpointService.get(), new TransformClusterStateListener(clusterService, client));
    }

    public UnaryOperator<Map<String, IndexTemplateMetaData>> getIndexTemplateMetaDataUpgrader() {
        return templates -> {
            try {
                templates.put(".transform-internal-003", TransformInternalIndex.getIndexTemplateMetaData());
            }
            catch (IOException e) {
                logger.error("Error creating data frame index template", (Throwable)e);
            }
            try {
                templates.put(".transform-notifications-000001", TransformInternalIndex.getAuditIndexTemplateMetaData());
            }
            catch (IOException e) {
                logger.warn("Error creating data frame audit index", (Throwable)e);
            }
            return templates;
        };
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        this.schedulerEngine.set((Object)new SchedulerEngine(this.settings, Clock.systemUTC()));
        assert (this.transformConfigManager.get() != null);
        assert (this.transformAuditor.get() != null);
        assert (this.transformCheckpointService.get() != null);
        return Collections.singletonList(new TransformPersistentTasksExecutor(client, (TransformConfigManager)this.transformConfigManager.get(), (TransformCheckpointService)this.transformCheckpointService.get(), (SchedulerEngine)this.schedulerEngine.get(), (TransformAuditor)((Object)this.transformAuditor.get()), threadPool, clusterService, settingsModule.getSettings()));
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(TransformTask.NUM_FAILURE_RETRIES_SETTING);
    }

    public void close() {
        if (this.schedulerEngine.get() != null) {
            ((SchedulerEngine)this.schedulerEngine.get()).stop();
        }
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return new TransformNamedXContentProvider().getNamedXContentParsers();
    }
}

