/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.util.Map;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeIndexer;
import org.elasticsearch.xpack.spatial.index.query.ShapeQueryProcessor;

public class ShapeFieldMapper
extends AbstractGeometryFieldMapper<Geometry, Geometry> {
    public static final String CONTENT_TYPE = "shape";

    public ShapeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, ignoreZValue, indexSettings, multiFields, copyTo);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public ShapeFieldType fieldType() {
        return (ShapeFieldType)super.fieldType();
    }

    public static final class ShapeFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType {
        public ShapeFieldType() {
        }

        public ShapeFieldType(ShapeFieldType ref) {
            super((AbstractGeometryFieldMapper.AbstractGeometryFieldType)ref);
        }

        public ShapeFieldType clone() {
            return new ShapeFieldType(this);
        }

        public String typeName() {
            return ShapeFieldMapper.CONTENT_TYPE;
        }

        protected AbstractGeometryFieldMapper.Indexer<Geometry, Geometry> geometryIndexer() {
            return this.geometryIndexer;
        }
    }

    public static class TypeParser
    extends AbstractGeometryFieldMapper.TypeParser {
        protected boolean parseXContentParameters(String name, Map.Entry<String, Object> entry, Map<String, Object> params) throws MapperParsingException {
            return false;
        }

        public Builder newBuilder(String name, Map<String, Object> params) {
            return new Builder(name);
        }
    }

    public static class Builder
    extends AbstractGeometryFieldMapper.Builder<AbstractGeometryFieldMapper.Builder, ShapeFieldMapper> {
        public Builder(String name) {
            super(name, (MappedFieldType)Defaults.FIELD_TYPE, (MappedFieldType)Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public ShapeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new ShapeFieldMapper(this.name, this.fieldType, this.defaultFieldType, (Explicit<Boolean>)this.ignoreMalformed(context), (Explicit<Boolean>)this.coerce(context), (Explicit<Boolean>)this.ignoreZValue(), context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo);
        }

        public ShapeFieldType fieldType() {
            return (ShapeFieldType)this.fieldType;
        }

        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            GeometryParser geometryParser = new GeometryParser(this.orientation == ShapeBuilder.Orientation.RIGHT, ((Boolean)this.coerce(context).value()).booleanValue(), ((Boolean)this.ignoreZValue().value()).booleanValue());
            this.fieldType().setGeometryIndexer(new ShapeIndexer(this.fieldType().name()));
            this.fieldType().setGeometryParser((parser, mapper) -> geometryParser.parse(parser));
            this.fieldType().setGeometryQueryBuilder(new ShapeQueryProcessor());
        }
    }

    public static class Defaults
    extends AbstractGeometryFieldMapper.Defaults {
        public static final ShapeFieldType FIELD_TYPE = new ShapeFieldType();
    }
}

