/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.frozen;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.engine.FrozenEngine;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.frozen.FrozenIndicesFeatureSetUsage;

public class FrozenIndicesFeatureSet
implements XPackFeatureSet {
    private final ClusterService clusterService;

    @Inject
    public FrozenIndicesFeatureSet(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public String name() {
        return "frozen_indices";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        int numFrozenIndices = 0;
        for (IndexMetaData indexMetaData : this.clusterService.state().metaData()) {
            if (!((Boolean)FrozenEngine.INDEX_FROZEN.get(indexMetaData.getSettings())).booleanValue()) continue;
            ++numFrozenIndices;
        }
        listener.onResponse((Object)new FrozenIndicesFeatureSetUsage(true, true, numFrozenIndices));
    }
}

