/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.searchafter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.sort.SortAndFormats;

public class SearchAfterBuilder
implements ToXContentObject,
Writeable {
    public static final ParseField SEARCH_AFTER = new ParseField("search_after", new String[0]);
    private static final Object[] EMPTY_SORT_VALUES = new Object[0];
    private Object[] sortValues = EMPTY_SORT_VALUES;

    public SearchAfterBuilder() {
    }

    public SearchAfterBuilder(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.sortValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.sortValues[i] = in.readGenericValue();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.sortValues.length);
        for (Object fieldValue : this.sortValues) {
            out.writeGenericValue(fieldValue);
        }
    }

    public SearchAfterBuilder setSortValues(Object[] values) {
        if (values == null) {
            throw new NullPointerException("Values cannot be null.");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Values must contains at least one value.");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i] instanceof String || values[i] instanceof Text || values[i] instanceof Long || values[i] instanceof Integer || values[i] instanceof Short || values[i] instanceof Byte || values[i] instanceof Double || values[i] instanceof Float || values[i] instanceof Boolean) continue;
            throw new IllegalArgumentException("Can't handle " + SEARCH_AFTER + " field value of type [" + values[i].getClass() + "]");
        }
        this.sortValues = new Object[values.length];
        System.arraycopy(values, 0, this.sortValues, 0, values.length);
        return this;
    }

    public Object[] getSortValues() {
        return Arrays.copyOf(this.sortValues, this.sortValues.length);
    }

    public static FieldDoc buildFieldDoc(SortAndFormats sort, Object[] values) {
        if (sort == null || sort.sort.getSort() == null || sort.sort.getSort().length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field.");
        }
        SortField[] sortFields = sort.sort.getSort();
        if (sortFields.length != values.length) {
            throw new IllegalArgumentException(SEARCH_AFTER.getPreferredName() + " has " + values.length + " value(s) but sort has " + sort.sort.getSort().length + ".");
        }
        Object[] fieldValues = new Object[sortFields.length];
        for (int i = 0; i < sortFields.length; ++i) {
            SortField sortField = sortFields[i];
            DocValueFormat format = sort.formats[i];
            fieldValues[i] = values[i] != null ? SearchAfterBuilder.convertValueFromSortField(values[i], sortField, format) : null;
        }
        return new FieldDoc(Integer.MAX_VALUE, 0.0f, fieldValues);
    }

    static SortField.Type extractSortType(SortField sortField) {
        if (sortField.getComparatorSource() instanceof IndexFieldData.XFieldComparatorSource) {
            return ((IndexFieldData.XFieldComparatorSource)sortField.getComparatorSource()).reducedType();
        }
        if (sortField instanceof SortedSetSortField) {
            return SortField.Type.STRING;
        }
        if (sortField instanceof SortedNumericSortField) {
            return ((SortedNumericSortField)sortField).getNumericType();
        }
        if ("LatLonPointSortField".equals(sortField.getClass().getSimpleName())) {
            return SortField.Type.DOUBLE;
        }
        return sortField.getType();
    }

    static Object convertValueFromSortField(Object value, SortField sortField, DocValueFormat format) {
        SortField.Type sortType = SearchAfterBuilder.extractSortType(sortField);
        return SearchAfterBuilder.convertValueFromSortType(sortField.getField(), sortType, value, format);
    }

    private static Object convertValueFromSortType(String fieldName, SortField.Type sortType, Object value, DocValueFormat format) {
        try {
            switch (sortType) {
                case DOC: {
                    if (value instanceof Number) {
                        return ((Number)value).intValue();
                    }
                    return Integer.parseInt(value.toString());
                }
                case SCORE: {
                    if (value instanceof Number) {
                        return Float.valueOf(((Number)value).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(value.toString()));
                }
                case INT: {
                    if (value instanceof Number) {
                        return ((Number)value).intValue();
                    }
                    return Integer.parseInt(value.toString());
                }
                case DOUBLE: {
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue();
                    }
                    return Double.parseDouble(value.toString());
                }
                case LONG: {
                    if (value instanceof Number) {
                        return ((Number)value).longValue();
                    }
                    return Long.parseLong(value.toString());
                }
                case FLOAT: {
                    if (value instanceof Number) {
                        return Float.valueOf(((Number)value).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(value.toString()));
                }
                case STRING_VAL: 
                case STRING: {
                    return format.parseBytesRef(value.toString());
                }
            }
            throw new IllegalArgumentException("Comparator type [" + sortType.name() + "] for field [" + fieldName + "] is not supported.");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse " + SEARCH_AFTER.getPreferredName() + " value for field [" + fieldName + "].", e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    void innerToXContent(XContentBuilder builder) throws IOException {
        builder.array(SEARCH_AFTER.getPreferredName(), this.sortValues);
    }

    public static SearchAfterBuilder fromXContent(XContentParser parser) throws IOException {
        SearchAfterBuilder builder = new SearchAfterBuilder();
        XContentParser.Token token = parser.currentToken();
        ArrayList<Object> values = new ArrayList<Object>();
        if (token == XContentParser.Token.START_ARRAY) {
            block6: while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    switch (parser.numberType()) {
                        case INT: {
                            values.add(parser.intValue());
                            continue block6;
                        }
                        case LONG: {
                            values.add(parser.longValue());
                            continue block6;
                        }
                        case DOUBLE: {
                            values.add(parser.doubleValue());
                            continue block6;
                        }
                        case FLOAT: {
                            values.add(Float.valueOf(parser.floatValue()));
                            continue block6;
                        }
                    }
                    throw new IllegalArgumentException("[search_after] does not accept numbers of type [" + (Object)((Object)parser.numberType()) + "], got " + parser.text());
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    values.add(parser.text());
                    continue;
                }
                if (token == XContentParser.Token.VALUE_BOOLEAN) {
                    values.add(parser.booleanValue());
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NULL) {
                    values.add(null);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.VALUE_STRING) + "] or [" + (Object)((Object)XContentParser.Token.VALUE_NUMBER) + "] or [" + (Object)((Object)XContentParser.Token.VALUE_BOOLEAN) + "] or [" + (Object)((Object)XContentParser.Token.VALUE_NULL) + "] but found [" + (Object)((Object)token) + "] inside search_after.", new Object[0]);
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.START_ARRAY) + "] in [" + SEARCH_AFTER.getPreferredName() + "] but found [" + (Object)((Object)token) + "] inside search_after", parser.getTokenLocation());
        }
        builder.setSortValues(values.toArray());
        return builder;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SearchAfterBuilder)) {
            return false;
        }
        return Arrays.equals(this.sortValues, ((SearchAfterBuilder)other).sortValues);
    }

    public int hashCode() {
        return Objects.hash(this.sortValues);
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.prettyPrint();
            this.toXContent(builder, EMPTY_PARAMS);
            return Strings.toString(builder);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build xcontent.", (Throwable)e, new Object[0]);
        }
    }
}

