/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.MultiBucketAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public abstract class AbstractRangeBuilder<AB extends AbstractRangeBuilder<AB, R>, R extends RangeAggregator.Range>
extends ValuesSourceAggregationBuilder<ValuesSource.Numeric, AB>
implements MultiBucketAggregationBuilder {
    protected final InternalRange.Factory<?, ?> rangeFactory;
    protected List<R> ranges = new ArrayList<R>();
    protected boolean keyed = false;

    protected AbstractRangeBuilder(String name, InternalRange.Factory<?, ?> rangeFactory) {
        super(name, rangeFactory.getValueSourceType(), rangeFactory.getValueType());
        this.rangeFactory = rangeFactory;
    }

    protected AbstractRangeBuilder(AbstractRangeBuilder<AB, R> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.rangeFactory = clone.rangeFactory;
        this.ranges = new ArrayList<R>(clone.ranges);
        this.keyed = clone.keyed;
    }

    protected AbstractRangeBuilder(StreamInput in, InternalRange.Factory<?, ?> rangeFactory, Writeable.Reader<R> rangeReader) throws IOException {
        super(in, rangeFactory.getValueSourceType(), rangeFactory.getValueType());
        this.rangeFactory = rangeFactory;
        this.ranges = in.readList(rangeReader);
        this.keyed = in.readBoolean();
    }

    protected RangeAggregator.Range[] processRanges(Function<RangeAggregator.Range, RangeAggregator.Range> rangeProcessor) {
        RangeAggregator.Range[] ranges = new RangeAggregator.Range[this.ranges.size()];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = rangeProcessor.apply((RangeAggregator.Range)this.ranges.get(i));
        }
        AbstractRangeBuilder.sortRanges(ranges);
        return ranges;
    }

    private static void sortRanges(final RangeAggregator.Range[] ranges) {
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                RangeAggregator.Range tmp = ranges[i];
                ranges[i] = ranges[j];
                ranges[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                int cmp = Double.compare(ranges[i].from, ranges[j].from);
                if (cmp == 0) {
                    cmp = Double.compare(ranges[i].to, ranges[j].to);
                }
                return cmp;
            }
        }.sort(0, ranges.length);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ranges.size());
        for (RangeAggregator.Range range : this.ranges) {
            range.writeTo(out);
        }
        out.writeBoolean(this.keyed);
    }

    public AB addRange(R range) {
        if (range == null) {
            throw new IllegalArgumentException("[range] must not be null: [" + this.name + "]");
        }
        this.ranges.add(range);
        return (AB)this;
    }

    public List<R> ranges() {
        return this.ranges;
    }

    public AB keyed(boolean keyed) {
        this.keyed = keyed;
        return (AB)this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RangeAggregator.RANGES_FIELD.getPreferredName(), this.ranges);
        builder.field(RangeAggregator.KEYED_FIELD.getPreferredName(), this.keyed);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ranges, this.keyed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractRangeBuilder other = (AbstractRangeBuilder)obj;
        return Objects.equals(this.ranges, other.ranges) && Objects.equals(this.keyed, other.keyed);
    }
}

