/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.MultiBucketAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public abstract class GeoGridAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.GeoPoint, GeoGridAggregationBuilder>
implements MultiBucketAggregationBuilder {
    static final ParseField FIELD_PRECISION = new ParseField("precision", new String[0]);
    static final ParseField FIELD_SIZE = new ParseField("size", new String[0]);
    static final ParseField FIELD_SHARD_SIZE = new ParseField("shard_size", new String[0]);
    protected int precision;
    protected int requiredSize;
    protected int shardSize;

    public static ObjectParser<GeoGridAggregationBuilder, Void> createParser(String name, PrecisionParser precisionParser) {
        ObjectParser<GeoGridAggregationBuilder, Void> parser = new ObjectParser<GeoGridAggregationBuilder, Void>(name);
        ValuesSourceParserHelper.declareGeoFields(parser, false, false);
        parser.declareField((p, builder, context) -> builder.precision(precisionParser.parse(p)), FIELD_PRECISION, ObjectParser.ValueType.INT);
        parser.declareInt(GeoGridAggregationBuilder::size, FIELD_SIZE);
        parser.declareInt(GeoGridAggregationBuilder::shardSize, FIELD_SHARD_SIZE);
        return parser;
    }

    public GeoGridAggregationBuilder(String name) {
        super(name, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
    }

    protected GeoGridAggregationBuilder(GeoGridAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.precision = clone.precision;
        this.requiredSize = clone.requiredSize;
        this.shardSize = clone.shardSize;
    }

    public GeoGridAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
        this.precision = in.readVInt();
        this.requiredSize = in.readVInt();
        this.shardSize = in.readVInt();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.precision);
        out.writeVInt(this.requiredSize);
        out.writeVInt(this.shardSize);
    }

    public abstract GeoGridAggregationBuilder precision(int var1);

    protected abstract ValuesSourceAggregatorFactory<ValuesSource.GeoPoint> createFactory(String var1, ValuesSourceConfig<ValuesSource.GeoPoint> var2, int var3, int var4, int var5, QueryShardContext var6, AggregatorFactory var7, AggregatorFactories.Builder var8, Map<String, Object> var9) throws IOException;

    public int precision() {
        return this.precision;
    }

    public GeoGridAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.requiredSize = size;
        return this;
    }

    public int size() {
        return this.requiredSize;
    }

    public GeoGridAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.shardSize = shardSize;
        return this;
    }

    public int shardSize() {
        return this.shardSize;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.GeoPoint> innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig<ValuesSource.GeoPoint> config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        int shardSize = this.shardSize;
        int requiredSize = this.requiredSize;
        if (shardSize < 0) {
            shardSize = BucketUtils.suggestShardSideQueueSize(requiredSize);
        }
        if (requiredSize <= 0 || shardSize <= 0) {
            throw new ElasticsearchException("parameters [required_size] and [shard_size] must be > 0 in " + this.getType() + " aggregation [" + this.name + "].", new Object[0]);
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        return this.createFactory(this.name, config, this.precision, requiredSize, shardSize, queryShardContext, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELD_PRECISION.getPreferredName(), this.precision);
        builder.field(FIELD_SIZE.getPreferredName(), this.requiredSize);
        if (this.shardSize > -1) {
            builder.field(FIELD_SHARD_SIZE.getPreferredName(), this.shardSize);
        }
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoGridAggregationBuilder other = (GeoGridAggregationBuilder)obj;
        return this.precision == other.precision && this.requiredSize == other.requiredSize && this.shardSize == other.shardSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.requiredSize, this.shardSize);
    }

    @FunctionalInterface
    protected static interface PrecisionParser {
        public int parse(XContentParser var1) throws IOException;
    }
}

