/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class GeoTileGridValuesSourceBuilder
extends CompositeValuesSourceBuilder<GeoTileGridValuesSourceBuilder> {
    static final String TYPE = "geotile_grid";
    private static final ObjectParser<GeoTileGridValuesSourceBuilder, Void> PARSER = new ObjectParser("geotile_grid");
    private int precision = 7;

    static GeoTileGridValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new GeoTileGridValuesSourceBuilder(name), null);
    }

    GeoTileGridValuesSourceBuilder(String name) {
        super(name);
    }

    GeoTileGridValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.precision = in.readInt();
    }

    public GeoTileGridValuesSourceBuilder precision(int precision) {
        this.precision = GeoTileUtils.checkPrecisionRange(precision);
        return this;
    }

    @Override
    public GeoTileGridValuesSourceBuilder format(String format) {
        throw new IllegalArgumentException("[format] is not supported for [geotile_grid]");
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeInt(this.precision);
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("precision", this.precision);
    }

    @Override
    String type() {
        return TYPE;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoTileGridValuesSourceBuilder other = (GeoTileGridValuesSourceBuilder)obj;
        return this.precision == other.precision;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig<?> config) throws IOException {
        Object orig = config.toValuesSource(queryShardContext);
        if (orig == null) {
            orig = ValuesSource.GeoPoint.EMPTY;
        }
        if (orig instanceof ValuesSource.GeoPoint) {
            ValuesSource.GeoPoint geoPoint = (ValuesSource.GeoPoint)orig;
            MappedFieldType fieldType = config.fieldContext() != null ? config.fieldContext().fieldType() : null;
            CellIdSource cellIdSource = new CellIdSource(geoPoint, this.precision, GeoTileUtils::longEncode);
            return new CompositeValuesSourceConfig(this.name, fieldType, cellIdSource, DocValueFormat.GEOTILE, this.order(), this.missingBucket());
        }
        throw new IllegalArgumentException("invalid source, expected geo_point, got " + orig.getClass().getSimpleName());
    }

    static {
        PARSER.declareInt(GeoTileGridValuesSourceBuilder::precision, new ParseField("precision", new String[0]));
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER, ValueType.NUMERIC);
    }
}

