/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.common.lucene.uid.PerThreadIDVersionAndSeqNoLookup;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class VersionsAndSeqNoResolver {
    static final ConcurrentMap<IndexReader.CacheKey, CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>> lookupStates = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private static final IndexReader.ClosedListener removeLookupState = key -> {
        CloseableThreadLocal ctl = (CloseableThreadLocal)lookupStates.remove(key);
        if (ctl != null) {
            ctl.close();
        }
    };

    private static PerThreadIDVersionAndSeqNoLookup[] getLookupState(IndexReader reader, String uidField) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookupState;
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]> ctl = (CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>)lookupStates.get(cacheHelper.getKey());
        if (ctl == null) {
            ctl = new CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>();
            CloseableThreadLocal other = lookupStates.putIfAbsent(cacheHelper.getKey(), ctl);
            if (other == null) {
                cacheHelper.addClosedListener(removeLookupState);
            } else {
                ctl = other;
            }
        }
        if ((lookupState = (PerThreadIDVersionAndSeqNoLookup[])ctl.get()) == null) {
            lookupState = new PerThreadIDVersionAndSeqNoLookup[reader.leaves().size()];
            for (LeafReaderContext leaf : reader.leaves()) {
                lookupState[leaf.ord] = new PerThreadIDVersionAndSeqNoLookup(leaf.reader(), uidField);
            }
            ctl.set(lookupState);
        }
        if (lookupState.length != reader.leaves().size()) {
            throw new AssertionError((Object)("Mismatched numbers of leaves: " + lookupState.length + " != " + reader.leaves().size()));
        }
        if (lookupState.length > 0 && !Objects.equals(lookupState[0].uidField, uidField)) {
            throw new AssertionError((Object)("Index does not consistently use the same uid field: [" + uidField + "] != [" + lookupState[0].uidField + "]"));
        }
        return lookupState;
    }

    private VersionsAndSeqNoResolver() {
    }

    public static DocIdAndVersion loadDocIdAndVersion(IndexReader reader, Term term, boolean loadSeqNo) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, term.field());
        List<LeafReaderContext> leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf = leaves.get(i);
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            DocIdAndVersion result = lookup.lookupVersion(term.bytes(), loadSeqNo, leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static DocIdAndSeqNo loadDocIdAndSeqNo(IndexReader reader, Term term) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, term.field());
        List<LeafReaderContext> leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf = leaves.get(i);
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            DocIdAndSeqNo result = lookup.lookupSeqNo(term.bytes(), leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static class DocIdAndSeqNo {
        public final int docId;
        public final long seqNo;
        public final LeafReaderContext context;

        DocIdAndSeqNo(int docId, long seqNo, LeafReaderContext context) {
            this.docId = docId;
            this.seqNo = seqNo;
            this.context = context;
        }
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final long seqNo;
        public final long primaryTerm;
        public final LeafReader reader;
        public final int docBase;

        public DocIdAndVersion(int docId, long version, long seqNo, long primaryTerm, LeafReader reader, int docBase) {
            this.docId = docId;
            this.version = version;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.reader = reader;
            this.docBase = docBase;
        }
    }
}

